//=============================================================================
// 第1版 - 初版
// 
// 
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 麻雀 (制御文字で麻雀牌を表示)
 * @author 
 * @base AP1S_MajiangCore
 * @orderAfter AP1S_MajiangCore
 * 
 * @help
 * 
 * 麻雀 (制御文字で麻雀牌を表示)
 * 
 * 制御文字が使用可能な場面で 次の制御文字で麻雀牌を表示します
 * 
 * \MJP[牌コード] 
 * 
 * 牌コードは最大2桁の数字で 表示する麻雀牌を指定します 
 * 対応する牌コードは 後述の「牌コード一覧」を参照してください 
 * 
 * また 牌コードは 
 * 次のように カンマ(,)で区切ることで連続して麻雀牌を表示できます
 * 
 * \MJP[1,2,3] (一萬,二萬,三萬の順子)
 * 
 * \MJP[26,26,26] (六筒の刻子)
 * 
 * \MJP[0,14,14,0] (四索の暗槓)
 * 
 * \MJP[1,9,11,19,21,29,31,32,33,34,35,36,37] 
 * (純正国士無双聴牌)
 * 
 * 
 * 
 * 
 * カンマ区切りの間に 牌コードではなく次の表示変更記号を入れることで 
 * 次に表示する牌の向き等を変更できます (小文字可)
 * 
 * R : 次の牌を右側に倒して表示
 * L : 次の牌を左側に倒して表示
 * JR : 次の2枚の牌を右側に倒して重ねて表示(加槓表示用)
 * JL : 次の2枚の牌を左側に倒して重ねて表示(加槓表示用)
 * P : 前の牌と次の牌の間にスペースを挿入
 * 
 * 
 * 表示変更記号使用例
 * 
 * \MJP[L,11,12,13] (上家から一索をチー)
 * 
 * \MJP[31,L,31,31] (対面から東をポン)
 * 
 * \MJP[37,37,JL,37,37] (下家からの中のポンに加槓)
 * 
 * \MJP[5,JL,5,10,5] (対面からの赤五萬のポンに五萬を加槓)
 * 
 * \MJP[5,JL,10,5,5] (対面からの五萬のポンに赤五萬を加槓)
 * 
 * 
 * 加槓の表示は 上側にはみ出して表示するため 改行を入れた後の表示を推奨します
 * 
 * 
 * 牌コード一覧---------
 * 
 * 
 * 裏面 : 0 
 * 
 * 一萬 : 1 
 * 二萬 : 2 
 * 三萬 : 3 
 * 四萬 : 4 
 * 五萬 : 5 
 * 六萬 : 6 
 * 七萬 : 7 
 * 八萬 : 8 
 * 九萬 : 9 
 * 五萬(赤ドラ) : 10 
 * 
 * 
 * 一索 : 11 
 * 二索 : 12 
 * 三索 : 13 
 * 四索 : 14 
 * 五索 : 15 
 * 六索 : 16 
 * 七索 : 17 
 * 八索 : 18 
 * 九索 : 19 
 * 五索(赤ドラ) : 20 
 * 
 * 
 * 一筒 : 21 
 * 二筒 : 22 
 * 三筒 : 23 
 * 四筒 : 24 
 * 五筒 : 25 
 * 六筒 : 26 
 * 七筒 : 27 
 * 八筒 : 28 
 * 九筒 : 29 
 * 五筒(赤ドラ) : 30 
 * 
 * 
 * 東 : 31 
 * 南 : 32 
 * 西 : 33 
 * 北 : 34 
 * 白 : 35 
 * 發 : 36 
 * 中 : 37 
 * 
 * 
 * 
 * 
 * 役の牌姿表示例---------
 * 
 * \MJP[2,3,4,13,13,21,21,22,23,23,33,33,33,P,22] 
 * (嵌張和了の一盃口)
 * 
 * \MJP[4,4,4,15,23,23,23,29,29,29,P,15,P,0,27,27,0] 
 * (七筒を暗槓して五索で和了した四暗刻単騎)
 * 
 * \MJP[2,3,4,21,21,35,35,37,37,P,37,P,L,36,36,36] 
 * (發をポンして中で和了した大三元)
 * 
 * \MJP[18,P,18,P,L,31,31,31,31,P,0,19,19,0,P,6,JL,6,6,6,P,JL,36,36,36,36]
 * (四槓子)
 * 
 * 
 */



( function()
{
	'use strict';
	
	//const P_name = decodeURIComponent(document.currentScript.src).match(/([^\/]+)\.js$/)[1]; //プラグイン名
	
	
	
	//----------------
	
	
	
	
	const _Window_Base_processEscapeCharacter = Window_Base.prototype.processEscapeCharacter;
	Window_Base.prototype.processEscapeCharacter = function(code, textState) 
	{
		if(code === "MJP")
		{
			this.processDrawMajiangPai(this.obtainJiangpaiCodeParam(textState), textState);
		}
		else
		{
			_Window_Base_processEscapeCharacter.apply(this,arguments);
		}
		
	};
	
	Window_Base.prototype.obtainJiangpaiCodeParam = function(textState) 
	{
    	const regExp = /^\[[\w,]+\]/;
    	const arr = regExp.exec(textState.text.slice(textState.index));
    	if (arr) 
    	{
    	    textState.index += arr[0].length;
    	    return this.parseJiangpaiCodeParam(arr[0].slice(1));
    	} 
    	else 
    	{
    	    return [];
    	}
	};
	
	Window_Base.prototype.parseJiangpaiCodeParam = function(text)
	{
		const direction = [];
		let jiagang = false;
		
		const ret = [];
		
		for(const t of text.split(","))
		{
			if(t.match(/J/i))
			{
				jiagang = true;
			}
			
			for(let i = 0; i < ((jiagang) ? 2 : 1); i++)
			{
				if(t.match(/R/i))
				{
					direction.push(1);
					
				}
				else if(t.match(/L/i))
				{
					direction.push(3);
				}
			}
			if(t.match(/P/i))
			{
				ret.push({"spacing": true});
				
			}
			const codeNumber = t.match(/\d+/);
    		if (codeNumber) 
    		{
    		    const d = direction.shift();
				const j = jiagang;
				const code = parseInt(codeNumber[0]);
				ret.push({"jiagang" : j , "direction" : d , "code": code});
				
				jiagang = false;
			}
    		   
			
			
			
		}
		return ret ;
		
		
	};
	
	
	Window_Base.prototype.processDrawMajiangPai = function(dataArray, textState) 
	{
		const paiHeight = this.lineHeight();
		const paiWidth = Math.floor(paiHeight * 0.75);
    	
    	for(const data of dataArray)
    	{
    		
    		if(data.spacing)
    		{
    			textState.x += Math.floor(paiWidth / 4);
    			continue;
	    	}
	    	
	    	const x = textState.x;
    		let y = textState.y;
    		const horizontal = [1,3].includes(data.direction);
    		if(horizontal)
    		{
    			if (data.jiagang)
    			{
    				y -= ((paiWidth * 2) - paiHeight);
    			}
    			else
    			{
    				y += (paiHeight - paiWidth)
    			}
    		}
    		if(textState.drawing) 
    		{
    	   		this.drawMajiangPaiCanvas(data.code,x, y,paiHeight , data.direction);
    	   	}
    	   	if(!data.jiagang)
    		{
    			textState.x += (horizontal) ? paiHeight : paiWidth;
    		}
    	    
    	}
    	
	};
	
	
	Window_Base.prototype.drawMajiangPaiCanvas = function(
   		code, x, y, height,direction
	) 	
	{
	    const pw = $dataMajiangSystem.imagePaiWidth;
    	const ph = $dataMajiangSystem.imagePaiHeight;
	    height = height || ph;
	    const width = Math.floor(height * 0.75);
	    const bitmap = $gameMajiangSystem.loadMajiangPai();
	    let type;
	    let value;
	    if(code === 0)
	    {
	    	type = 3;
	    	value = 8;
	    }
	    else
	    {
	    	type = Math.floor(code / 10);
	    	value = code % 10;
	    	if(value === 0)
	    	{
	    		value = 10;
	    		type -= 1;
			}
		}
	    const sw = Math.min(width, pw);
	    const sh = Math.min(height, ph);
	    const dx = Math.floor(x);
	    const dy = Math.floor(y);
	    const sx = Math.floor((value - 1) * pw);
	    const sy = Math.floor((type) * ph);
	    
	    
	    
	    this.contents.bltMajiangPai(bitmap, sx, sy , pw, ph, dx, dy , width ,height ,direction);
	};
	
	Bitmap.prototype.bltMajiangPai = function(source, sx, sy, sw, sh, dx, dy, dw, dh,direction) 
	{
    	dw = dw || sw;
    	dh = dh || sh;
    	try 
    	{
			const image = source._image;
        	this.context.globalCompositeOperation = "source-over";
        	
        	if(direction)
        	{
        		const context = this.context;
        		
        		context.save();
    			
    			if(direction === 1)
    			{
    				context.translate(dx  + dh,dy);
    				context.rotate(90 * Math.PI / 180);
    			}
    			else
    			{
    				context.translate(dx,dy + dw);
    				context.rotate(270 * Math.PI / 180);
    			}
    			
    			
    			context.drawImage(image, sx,sy, sw, sh, 0, 0, dw, dh);
    			
    			context.restore();
	    	}
	    	else
	    	{
        		this.context.drawImage(image, sx, sy, sw, sh, dx, dy, dw, dh);
        	}
        	
        	this._baseTexture.update();
    	}
    	catch (e) 
    	{
        	//
    	}
	};
	const _Scene_Boot_loadSystemImages = Scene_Boot.prototype.loadSystemImages;
	Scene_Boot.prototype.loadSystemImages = function() 
	{
		_Scene_Boot_loadSystemImages.apply(this,arguments);
    	$gameMajiangSystem.loadMajiangPai();
	};
	
	
	
})();













