//=============================================================================
// 第1版 - 初版
// 第2版 - 麻雀牌画像の呼び出し先を変更
// 第3版 - 対局中ボイスに対応
// 第4版 - 供託棒と積み棒を和了リザルト画面で表示するように変更
// 第8版 - フォントサイズの変更に対応
// 第9版3刷 - ゲームルール一時固定中にオプション画面を開くと設定が変更される不具合を修訂
// 第10版 - 流し満貫のリザルト表示ウィンドウを改行して表示するように変更
// 第12版 - 副露、自摸アクション選択肢ウィンドウに 対象牌を表示できる機能を追加
//          マウス操作時の操作性を改善
// 
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 麻雀 (ウィンドウ)
 * @author 
 * @base AP1S_MajiangCore
 * @orderAfter AP1S_MajiangCore
 * 
 * @help
 * 
 * ミニゲーム 麻雀
 * 
 * 詳細な使用方法は 同梱の説明書をご覧ください
 * 
 * 
 * 
 */


function Window_MajiangBase() 
{
    this.initialize(...arguments);
}

Window_MajiangBase.prototype = Object.create(Window_Base.prototype);
Window_MajiangBase.prototype.constructor = Window_MajiangBase;



function Window_MajiangTehai() 
{
    this.initialize(...arguments);
}
	
Window_MajiangTehai.prototype = Object.create(Window_Selectable.prototype);
Window_MajiangTehai.prototype.constructor = Window_MajiangTehai;



function Window_MajiangStatus() 
{
    this.initialize(...arguments);
}

Window_MajiangStatus.prototype = Object.create(Window_MajiangBase.prototype);
Window_MajiangStatus.prototype.constructor = Window_MajiangStatus;


function Window_MajiangBattlerStatus() 
{
    this.initialize(...arguments);
}

Window_MajiangBattlerStatus.prototype = Object.create(Window_MajiangBase.prototype);
Window_MajiangBattlerStatus.prototype.constructor = Window_MajiangBattlerStatus;


function Window_MajiangFuriten() 
{
    this.initialize(...arguments);
}

Window_MajiangFuriten.prototype = Object.create(Window_MajiangBase.prototype);
Window_MajiangFuriten.prototype.constructor = Window_MajiangFuriten;

function Window_MajiangTingpaiMachi() 
{
    this.initialize(...arguments);
}

Window_MajiangTingpaiMachi.prototype = Object.create(Window_MajiangBase.prototype);
Window_MajiangTingpaiMachi.prototype.constructor = Window_MajiangTingpaiMachi;


function Window_MajiangMessage() 
{
    this.initialize(...arguments);
}

Window_MajiangMessage.prototype = Object.create(Window_MajiangBase.prototype);
Window_MajiangMessage.prototype.constructor = Window_MajiangMessage;

function Window_MajiangChoice() 
{
    this.initialize(...arguments);
}

Window_MajiangChoice.prototype = Object.create(Window_Command.prototype);
Window_MajiangChoice.prototype.constructor = Window_MajiangChoice;


function Window_MajiangResultTehai() 
{
    this.initialize(...arguments);
}

Window_MajiangResultTehai.prototype = Object.create(Window_MajiangBase.prototype);
Window_MajiangResultTehai.prototype.constructor = Window_MajiangResultTehai;

function Window_MajiangResultYaku() 
{
    this.initialize(...arguments);
}

Window_MajiangResultYaku.prototype = Object.create(Window_MajiangBase.prototype);
Window_MajiangResultYaku.prototype.constructor = Window_MajiangResultYaku;

function Window_MajiangResultPoint() 
{
    this.initialize(...arguments);
}

Window_MajiangResultPoint.prototype = Object.create(Window_MajiangBase.prototype);
Window_MajiangResultPoint.prototype.constructor = Window_MajiangResultPoint;

function Window_MajiangResultFinalPoint() 
{
    this.initialize(...arguments);
}

Window_MajiangResultFinalPoint.prototype = Object.create(Window_MajiangBase.prototype);
Window_MajiangResultFinalPoint.prototype.constructor = Window_MajiangResultFinalPoint;


function Window_MajiangEndMenu() 
{
    this.initialize(...arguments);
}

Window_MajiangEndMenu.prototype = Object.create(Window_Command.prototype);
Window_MajiangEndMenu.prototype.constructor = Window_MajiangEndMenu;


function Window_MajiangOptions() 
{
    this.initialize(...arguments);
}

Window_MajiangOptions.prototype = Object.create(Window_Command.prototype);
Window_MajiangOptions.prototype.constructor = Window_MajiangOptions;

(function() 
{
	"use strict";
	
	Window_MajiangBase.prototype.initialize = function(rect)
	{
		Window_Base.prototype.initialize.call(this, rect);
	};
	
	Window_MajiangBase.prototype.createMajiangPaiBase = function()
	{
		if(!this._majiangPaizi)
		{
			this._majiangPaizi = [];
		}
		if(!this._majiangPaiBase)
		{
			const base = new Sprite();
			
			base.width = this.innerWidth;
			base.height = this.innerHeight;
			base.x = 0;
			base.y = 0;
			this._clientArea.addChild(base);
			this._majiangPaiBase = base;
		}
	}
	Window_MajiangBase.prototype.drawPaizi = function(x,y,paizi,height,direction = 0,maxCols,maxRows)
	{
		this.createMajiangPaiBase();
		const rect = new Rectangle(x,y,this.width,this.height);
		const majiangPai = new Spriteset_MajiangPaizi(rect,direction,height);
		if(maxCols)
		{
			majiangPai.setMaxCols(maxCols);
		}
		if(maxRows)
		{
			majiangPai.setMaxRows(maxRows);
		}
		majiangPai.addPaizi(paizi,0,0);
		this._majiangPaiBase.addChild(majiangPai);
		
		this._majiangPaizi.push(majiangPai);
	};
	
	Window_MajiangBase.prototype.drawFulu = function(x,y,fulu,height,direction = 0)
	{
		this.createMajiangPaiBase();
		const rect = new Rectangle(x,y,this.width,this.height);
		const majiangPai = new Spriteset_MajiangPaizi(rect,direction,height);
		majiangPai.addFulu(fulu,0,0);
		this._majiangPaiBase.addChild(majiangPai);
		
		
		this._majiangPaizi.push(majiangPai);
	};
	Window_MajiangBase.prototype.drawTehai = function(x,y,width,battler,height,direction = 0)
	{
		this.createMajiangPaiBase();
		const rect = new Rectangle(x,y,width,this.height);
		
		const majiangPai = new Spriteset_MajiangPaizi(rect,direction,height);
		majiangPai.echoTehai(battler.tehai(),battler.fulu());
		this._majiangPaiBase.addChild(majiangPai);
		this._majiangPaizi.push(majiangPai);
	};
	
	
	
	Window_MajiangBase.prototype.destroyMajiangpai = function()
	{
		if(this._majiangPaizi)
		{
			for(const paizi of this._majiangPaizi)
			{
				paizi.destroyPaizi();
			}
			this._majiangPaizi = [];
		}
	};
	
	Window_MajiangBase.prototype.drawMajiangFace = function(
    	battler, x, y, width, height
	) 	
	{
		
		const actor = battler.actor();
		
		const faceIndex = actor.faceIndex();
		const faceName = actor.faceName();
		
    	width = width || ImageManager.faceWidth;
    	height = height || ImageManager.faceHeight;
    	const bitmap = ImageManager.loadFace(faceName);
    	const pw = ImageManager.faceWidth;
    	const ph = ImageManager.faceHeight;
    	const sw = pw;
    	const sh = ph;
    	const dx = Math.floor(x);//Math.floor(x + Math.max(width - pw, 0) / 2);
    	const dy = Math.floor(y);//yMath.floor(y + Math.max(height - ph, 0) / 2);
    	const sx = Math.floor((faceIndex % 4) * pw + (pw - sw) / 2);
    	const sy = Math.floor(Math.floor(faceIndex / 4) * ph + (ph - sh) / 2);
    	const dw = Math.floor(width);
    	const dh = Math.floor(height);
    	
    	this.contents.blt(bitmap, sx, sy, sw, sh, dx, dy, dw, dh);
    	
	};
	
	Window_MajiangBase.prototype.drawBattlerName = function(battler, x, y, width,align) 	
	{
		const feng = battler.menfeng();
		const name = battler.name();
		const text1 = this.menfengText(feng);
		const text1Width = this.textWidth(text1);
		const text2 = name;
		if(feng === 1)
		{
			this.changeTextColor(ColorManager.textColor($dataMajiangSystem.params.dongjiaTextColor));
		}
		this.drawText(text1,x,y,text1Width);
		this.resetTextColor();
		const padding = this.itemPadding();
		const text2X = x + text1Width + padding;
		const text2w = width - (text1Width + padding);
		
		this.drawText(text2,text2X,y,text2w,"center");
		
	};
	
	Window_MajiangBase.prototype.menfengText = function(feng)
	{
		const fengText = $dataMajiangSystem.text[["","dong","nan","xi","bei"][feng]];
		return $dataMajiangSystem.text.jia.format(fengText);
	};
	
	Window_MajiangBase.prototype.pointValue = function(value)
	{
		return ((value > Number.MAX_SAFE_INTEGER || value < Number.MIN_SAFE_INTEGER) ? (BigInt(value) + "") : value)
	};
		
	
	Window_MajiangBase.prototype.drawTembo = function(point,x, y, width) 
	{
		const bitmap = $gameMajiangSystem.loadMajiangPai();
		const paiWidth = $dataMajiangSystem.imagePaiWidth;
		const paiHeight = $dataMajiangSystem.imagePaiHeight;
    	const pw = paiWidth;
    	const ph = pw / 2;
    	const sx = paiWidth * (4 + ((point === 1000) ? 0 : 1));
    	const sy = paiHeight * 4;
    	this.contents.blt(bitmap, sx, sy, pw, ph, x, y ,Math.floor(width)  , Math.floor(width / 2));
	};
	Window_MajiangBase.prototype.temboWidth = function() 
	{
		return this.textWidth("000");
	};
	
	Window_MajiangBase.prototype.drawChangStatus = function(x, y, width) 
	{
		const text = MajiangManager.textCurrentChangStatus();
		const textWidth = this.textWidth(text);
    	this.drawText(text, x, y, textWidth);
    	
    	
    	const temboStatusWidth = (this.temboWidth() * 2);
    	const temboStatusX = x + (width - temboStatusWidth);
    	
    	this.drawTemboStatus(temboStatusX ,y,temboStatusWidth);
	};
	
	Window_MajiangBase.prototype.drawTemboStatus = function(x, y, width)
	{
		const temboWidth = this.temboWidth();
		
		const tembo1X = x;
		const tembo2X = tembo1X + temboWidth + this.itemPadding();
		
		const offsetYbo = y - Math.floor(this.lineHeight() / 8);//5;
		const offsetYtext = y + Math.floor(this.lineHeight() / 6); // 8
		
		const text1 = MajiangManager.lizhibo();
		const text2 = MajiangManager.tsumibo();
		
		this.drawTembo(1000 , tembo1X,offsetYbo,temboWidth);
		this.drawTembo(100 , tembo2X ,offsetYbo,temboWidth);
		
		this.drawText(text1,tembo1X,offsetYtext,temboWidth,"center");
		
		this.drawText(text2,tembo2X,offsetYtext,temboWidth,"center");
	};
	
	
	
	Window_MajiangBase.prototype.lineHeight = function()
	{
		return $dataMajiangSystem.params.lineHeight || Window_Base.prototype.lineHeight.call(this);
		
	};
	
	Window_MajiangBase.prototype.resetFontSettings = function() 
	{
		Window_Base.prototype.resetFontSettings.call(this);
		const fontSize = $dataMajiangSystem.params.fontSize;
		if(fontSize)
		{
			this.contents.fontSize = fontSize;
		}
    	
	};
	
	
	//----------------------
	
	Window_MajiangTehai.prototype.initialize = function(rect) 
	{
		this._paizi = [];
		this._zimo = false;
		this._paiSprites = [];
		this._tingpaiMachiWindow = null;
		
    	Window_Selectable.prototype.initialize.call(this, rect);
    	this._canRepeat = $dataMajiangSystem.params.tehaiCanRepeat;
    	this.opacity = 0;
    	this.padding = 0;
	};
	
	Window_MajiangTehai.prototype.setTehai = function(paizi)
	{
		this._paizi = paizi || [];
		
		this.refresh();
	};
	Window_MajiangTehai.prototype.setTingpaiMachiWindow = function(tingpaiMachiWindow)
	{
		this._tingpaiMachiWindow = tingpaiMachiWindow;
	};
	
	Window_MajiangTehai.prototype.selectZimopai = function()
	{
		const index = this._paizi.findIndex(p => p.isZimoPai());
		if(index !== -1)
		{
			this.select(index);
		}
		else
		{
			this.select(0);
		}
		if(this.isOpenAndActive())
		{
			this.onTouchSelect(false);
		}
	};
	
	Window_MajiangTehai.prototype.clearPaisprites = function()
	{
		for(const sprite of this._paiSprites)
    	{
    		this.removeChild(sprite);
    		sprite.destroy();
    	}
    	this._paiSprites = [];
	};
	
	Window_MajiangTehai.prototype.refresh = function() 
	{
    	this.clearPaisprites();
    	this.width = this._paizi.length * this.itemWidth() + this.zimoSpacing();
    	Window_Selectable.prototype.refresh.call(this);
	};
	
	Window_MajiangTehai.prototype.itemWidth = function() 
	{
    	return $dataMajiangSystem.paiWidth;
	};
	
	Window_MajiangTehai.prototype.itemHeight = function() 
	{
    	return $dataMajiangSystem.paiHeight;
	};
	
	Window_MajiangTehai.prototype.zimoSpacing = function() 
	{
    	return $dataMajiangSystem.zimoSpacing;
	};
	
	
	Window_MajiangTehai.prototype.itemRect = function(index) 
	{
    	const maxCols = this.maxCols();
    	const itemWidth = this.itemWidth();
    	const itemHeight = this.itemHeight();
    	const col = index % maxCols;
    	const row = Math.floor(index / maxCols);
    	let x = col * itemWidth - this.scrollBaseX();
    	if(this._paizi[index] && this._paizi[index].needSpacing())
    	{
    		x += this.zimoSpacing();
	    }
    	const y = row * itemHeight - this.scrollBaseY();
    	const width = itemWidth;
    	const height = itemHeight;
    	return new Rectangle(x, y, width, height);
	};
	
	Window_MajiangTehai.prototype.maxItems = function() 
	{
    	return this._paizi.length;
	};
	
	Window_MajiangTehai.prototype.maxCols = function() 
	{
    	return 14;
	};
	
	Window_MajiangTehai.prototype.drawPai = function(pai,x,y ,direction) 
	{
		const px = x + this.itemWidth() / 2;
		const py = y + this.itemHeight() / 2;
		const paiSprite = new Sprite_MajiangPai(pai,px,py,direction,$dataMajiangSystem.paiHeight);
		this._paiSprites.push(paiSprite);
		this.addInnerChild(paiSprite);
	};
	
	Window_MajiangTehai.prototype.drawItem = function(index) 
	{
    	const rect = this.itemRect(index);
    	const pai = this._paizi[index];
    	this.drawPai(pai,rect.x,rect.y,"");
	};
	
	Window_MajiangTehai.prototype.select = function(index) 
	{
    	Window_Selectable.prototype.select.call(this, index);
    	
    	this.selectPai(index);
	};
	
	Window_MajiangTehai.prototype.activate = function() 
	{
		if(this._tingpaiMachiWindow)
		{
			this._tingpaiMachiWindow.close();
			this._tingpaiMachiWindow.canOpen = true;
		}
		Window_Selectable.prototype.activate.call(this);
	};
	
	Window_MajiangTehai.prototype.item = function() 
	{
    	return this._paizi[this.index()];
	};
	Window_MajiangTehai.prototype.isCurrentItemEnabled = function() 
	{
    	return this.item().isEnabled();
	};
	
	Window_MajiangTehai.prototype.selectPai = function(index) 
	{
		const length = this._paizi.length;
		const tingpaiWindow = this._tingpaiMachiWindow;
		for (let i = 0; i < length ; i++) 
		{
        	if (i === index)
        	{
        	    this._paizi[i].select();
        	    this._tingpaiMachiWindow?.setDapai(this._paizi[i].code());
        	}
        	else 
        	{
        	    this._paizi[i].deselect();
        	}
        }
		this._tingpaiMachiWindow?.refresh();
	};
	Window_MajiangTehai.prototype.playOkSound = function() 
	{
    	//
	};
	
	
	Window_MajiangTehai.prototype.refreshCursor = function() 
	{
    	//
	};
	Window_MajiangTehai.prototype.drawItemBackground = function()
	{
		//
	};
	Window_MajiangTehai.prototype.paizi = function()
	{
		return this._paiSprites;
	};
	
	
	//-------------
	/*
	Window_MajiangPaiselect.prototype.initialize = function(rect) 
	{
		this._paizi = [];
		this._zimo = false;
		Window_Selectable.prototype.initialize.call(this, rect);
	}
	
	
	Window_MajiangPaiselect.prototype.zimoSpacing = function() 
	{
    	return 0;
	};
	Window_MajiangPaiselect.prototype.itemWidth = function() 
	{
    	return $dataMajiangSystem.tajiaPaiWidth;
	};
	
	Window_MajiangPaiselect.prototype.itemHeight = function() 
	{
    	return $dataMajiangSystem.tajiaPaiHeight;
	};
	*/
	
	//---------------
	
	Window_MajiangStatus.prototype.initialize = function(rect) 
	{
    	Window_MajiangBase.prototype.initialize.call(this, rect);
    	this.openness = 0;
	};
	
	Window_MajiangStatus.prototype.refresh = function()
	{
		this.destroyMajiangpai();
		this.contents.clear();
		const rect = this.baseTextRect();
		
		const statusWidth = rect.width ;
		this.drawChangStatus(rect.x , rect.y ,statusWidth);
		const doraY = rect.y + (this.lineHeight() + this.itemPadding());
		this.drawDora(rect.x , doraY ,statusWidth);
		
		this.drawShengyu(rect.x , doraY ,rect.width);
		
	};
	
	
	Window_MajiangStatus.prototype.drawDora = function(x, y) 
	{
		if($gameMajiangSystem.gamerule.dora)
		{
			const paizi = $gameMajiangPaishan.echoDora();
			this.drawPaizi(x,y,paizi);
		}
	};
	
	Window_MajiangStatus.prototype.drawShengyu = function(x, y , width) 
	{
		const text = $gameMajiangPaishan.shengyu();
		
		this.drawText(text,x,y,width,"right");
	};
	
	//--------------------------------
	
	Window_MajiangBattlerStatus.prototype.initialize = function(rect) 
	{
		
		Window_MajiangBase.prototype.initialize.call(this, rect);
		
		this.openness = 0;
    	
		this._battler = null;
		
		
		this._direction = -1;
		
		this._vertical = false;
		
		
	};
	Window_MajiangBattlerStatus.prototype.updatePadding = function() 
	{
   		this.padding = 0;
	};
	
	Window_MajiangBattlerStatus.prototype.setBattler = function(battler,direction) 
	{
		this._battler = battler;
		
		if(this._direction === -1)
		{
			this.setDirection(direction)
		}
		
		this.refresh();
	};
	
	Window_MajiangBattlerStatus.prototype.refresh = function() 
	{
		if (this.contents) 
		{
        	this.contents.clearRect(0, 0, this.realWidth(), this.realHeight());
    	}
    	
		this.drawStatus();
	};
	
	Window_MajiangBattlerStatus.prototype.setDirection = function(direction) 
	{
		switch (direction)
		{
			case 1 : 
				this.contents.context.translate(0,this.innerHeight);
				this.contents.context.rotate(270 * Math.PI/180);
			break;
			case 3 : 
				this.contents.context.translate(this.innerWidth,0);
    			this.contents.context.rotate(90 * Math.PI/180);
        	break;
    	}
    	this._direction = direction;
    	
    	this._vertical = (direction == 1 || direction === 3);
	};
	
	Window_MajiangBattlerStatus.prototype.statusTextRect = function() 
	{
		const tw = this.realInnerWidth() - (this.itemPadding() * 4);
		const th = this.lineHeight();
		
		const tx = Math.floor((this.realInnerWidth() - tw) / 2);
		const ty = Math.floor((this.realInnerHeight() - th) / 2);
		
		return new Rectangle(tx,ty,tw,th);
	};
	Window_MajiangBattlerStatus.prototype.realHeight = function() 
	{
		return (this._vertical) ? this.width : this.height;
	}
	Window_MajiangBattlerStatus.prototype.realWidth = function() 
	{
		return (this._vertical) ? this.height : this.width;
	}
	
	Window_MajiangBattlerStatus.prototype.realInnerHeight = function() 
	{
		return (this._vertical) ? this.innerWidth : this.innerHeight;
	};
	Window_MajiangBattlerStatus.prototype.realInnerWidth = function() 
	{
		return (this._vertical) ? this.innerHeight : this.innerWidth;
	};
	
	Window_MajiangBattlerStatus.prototype.drawStatus = function() 
	{
		
		const rect = this.statusTextRect();
		
		
		const maxWidth = rect.width;
		
		const padding = this.itemPadding();
		
		const drawFace = $dataMajiangSystem.params.drawFace;
		
		const faceWidth = (drawFace) ? (rect.height + (padding * 2)) : 0;
		
		const nameWidth = Math.floor(rect.width * 0.6);
		
		const pointWidth = rect.width - (faceWidth + nameWidth);
		
		const nameX = rect.x + faceWidth + padding;
		
		const pointX = rect.x + faceWidth + nameWidth + padding;
		
		
		
		
		
		if(drawFace)
		{
		
			this.drawMajiangFace(this._battler, rect.x + padding, rect.y,rect.height,rect.height);
		}
		this.drawBattlerName(this._battler,nameX,rect.y,nameWidth - padding,"center");
		
		this.drawPoint(this._battler,pointX,rect.y,pointWidth - padding);
		
	};
	
	
	
	Window_MajiangBattlerStatus.prototype.drawPoint = function(battler,x,y,width)
	{
		
		const point = battler.point();
		const pointText = $dataMajiangSystem.text.point.format(this.pointValue(point));
		
		
		this.drawText(pointText,x,y,width,"right");
		
	};
	
	
	
	
	//----------------------
	
	Window_MajiangFuriten.prototype.initialize = function(rect) 
	{
		this.originPadding = this.padding;
		Window_MajiangBase.prototype.initialize.call(this, rect);
		this.openness = 0;
		
		this._battler = null;
		
		this.setPlacement();
		
		this.refresh();
		
	};
	Window_MajiangFuriten.prototype.updatePadding = function() 
	{
   		this.padding = 0;
	};
	
	Window_MajiangFuriten.prototype.refresh = function() 
	{
		this.contents.clear();
		this.drawFuritenText();
		if(this.checkFuriten())
		{
			this.forceOpen();
		}
		else
		{
			this.close();
		}
	};
	
	Window_MajiangFuriten.prototype.setPlacement = function() 
	{
		const width = this.windowWidth(this.x);
		const x = this.x - width;
		this.width = width;
		this.x = x;
		this.createContents();
	};
	
	Window_MajiangFuriten.prototype.windowWidth = function(x) 
	{
		const text = this.furitenText();
		const textWidth = this.textSizeEx(text).width;
		const padding = this.padding + this.itemPadding();
		const width = Math.ceil(textWidth) + (padding * 2);
		return Math.min(width, x);
		
	}
	
	Window_MajiangFuriten.prototype.open = function()
	{
		if(this.checkFuriten())
		{
			this.forceOpen();
		}
	};
	Window_MajiangFuriten.prototype.forceOpen = function()
	{
		Window_MajiangBase.prototype.open.call(this);
	};
	Window_MajiangFuriten.prototype.checkFuriten = function()
	{
		return (this._battler && this._battler.isFuriten());
	};
	Window_MajiangFuriten.prototype.setBattler = function(battler) 
	{
		this._battler = battler;
	};
	
	Window_MajiangFuriten.prototype.furitenText = function() 
	{
		return $dataMajiangSystem.text.furiten;
	};
	Window_MajiangFuriten.prototype.textY = function() 
	{
		return Math.floor((this.innerHeight - this.lineHeight()) / 2);
	};
	
	Window_MajiangFuriten.prototype.drawFuritenText = function() 
	{
		const text = this.furitenText();
		
		const padding = $gameSystem.windowPadding();
		const textWidth = this.innerWidth - (padding * 2)
		this.drawText(text, padding,this.textY(),textWidth,"center");
	};
	
	
	
	//----------------------
	
	Window_MajiangTingpaiMachi.prototype.initialize = function(rect) 
	{
		Window_MajiangBase.prototype.initialize.call(this, rect);
		this.openness = 0;
		this._battler = null;
		this._machi = [];
		this._originY = this.y;
		this._dapai = null;
		this.canOpen = false;
		
		this.refresh();
	};
	
	Window_MajiangTingpaiMachi.prototype.setDapai = function(dapai) 
	{
		this._dapai = dapai;
	};
	Window_MajiangTingpaiMachi.prototype.setTehaiWindowActive = function(status) 
	{
		this._tehaiWindowActive = status;
	};
	
	Window_MajiangTingpaiMachi.prototype.refresh = function() 
	{
		this.setMachi();
		if(this.checkOpen())
		{
			this.destroyMajiangpai();
			this.contents.clear();
			this.drawTingpaiMachi();
			this.forceOpen();
		}
		else
		{
			this.close();
		}
	};
	
	Window_MajiangTingpaiMachi.prototype.checkOpen = function()
	{
		return (this.canOpen && this._machi.length > 0);
	};
	
	Window_MajiangTingpaiMachi.prototype.open = function()
	{
		this.refresh();
	};
	
	Window_MajiangTingpaiMachi.prototype.forceOpen = function()
	{
		Window_MajiangBase.prototype.open.call(this);
	};
	
	Window_MajiangTingpaiMachi.prototype.setMachi = function(dapai)
	{
		this._machi = this.checkMachi(dapai);
	};
	
	Window_MajiangTingpaiMachi.prototype.checkMachi = function()
	{
		if(!this._battler) return [];
		
		if(this._dapai)
		{
			const tingpai = this._battler.canTingpaiResult().find(d => d.qiepai.code() === this._dapai);
			this._dapai = null;
			if(tingpai)
			{
				return tingpai.machi;
			}
			
		}
		else if(this._battler.isTingpai())
		{
			return this._battler.tingpaiMachi().map(d => d.machi)
		}
		return [];
	};
	
	Window_MajiangTingpaiMachi.prototype.setBattler = function(battler) 
	{
		this._battler = battler;
	};
	
	Window_MajiangTingpaiMachi.prototype.update = function() 
	{
		if(!this.canOpen)
		{
			this.close();
		}
		Window_MajiangBase.prototype.update.call(this);
	};
	/*
	Window_MajiangTingpaiMachi.prototype.isEnabled = function() 
	{
		const setting = $dataMajiangSystem.params.tingpaiMachiWindow;
		if(!MajiangManager.canCalledGameEndMenu() || !setting)
		{
			return false;
		}
		if(setting === 2
			&& !this._tehaiWindowActive
		)
		{
			return false;
		}
		return true;
		
	}*/
	
	Window_MajiangTingpaiMachi.prototype.drawTingpaiMachi = function() 
	{
		this.refreshWindowWidth(this._machi.length);
		const rect = this.baseTextRect();
		let x = rect.x;
		const y = rect.y;
		for(const code of this._machi)
		{
			this.drawItem(code,x,y);
			x += (this.itemWidth() + this.paiPadding());
		}
	};
	
	
	Window_MajiangTingpaiMachi.prototype.drawItem = function(code,x,y) 
	{
		const pai = $gameMajiangPaishan.makeDummyPai(code);
		const maxNum = $gameMajiangPaishan.maxPaiNum(code);
		const num = maxNum - this._battler.visiblePaizi(true)[code];
		if(num === 0)
		{
			pai.setEnabled(false);
		}
		const itemWidth = this.itemWidth();
		const paiX = x + Math.floor((itemWidth - this.paiWidth()) / 2);
		this.drawPaizi(paiX,y,[pai],this.paiHeight());
		const numberY = y + this.paiHeight();
		
		this.drawText(num,x,numberY,itemWidth,"center");
	};
	
	Window_MajiangTingpaiMachi.prototype.paiHeight = function() 
	{
    	return this.lineHeight();
    };
    
    Window_MajiangTingpaiMachi.prototype.paiWidth = function() 
	{
    	return Math.floor(this.paiHeight() * 0.75);
    };
    Window_MajiangTingpaiMachi.prototype.numberHeight = function() 
	{
		return this.lineHeight() - Math.floor((this.lineHeight() - this.contents.fontSize) / 2);
	};
   
    
    Window_MajiangTingpaiMachi.prototype.itemHeight = function() 
	{
		return this.paiHeight() + this.numberHeight();
	};
	
	Window_MajiangTingpaiMachi.prototype.paiPadding = function() 
	{
		return this.itemPadding();
	};
	
	Window_MajiangTingpaiMachi.prototype.itemWidth = function() 
	{
		return this.paiWidth();
	};
	
	Window_MajiangTingpaiMachi.prototype.refreshWindowWidth = function(itemNum) 
	{
		const paiPadding = this.paiPadding();
		const width = Math.max(0 , ((this.itemWidth() + paiPadding) * itemNum) - paiPadding);
		const height = this.itemHeight();
		this.width = width + (this.padding * 2) + (this.itemPadding() * 2);
		this.height = height + (this.padding * 2);
		this.y = this._originY - this.height;
		this.createContents();
		//this.setBackgroundType(0);
	};
	
	
	//----------------------
	
	
	Window_MajiangMessage.prototype.initialize = function(rect) 
	{
    	Window_MajiangBase.prototype.initialize.call(this, rect);
    	this.openness = 0;
    	this._battler = null;
    	this._message = "";
    	this._nameBoxWindow = null;
    	this._waitCount = 0;
    	this._drawn = true;
	};
	
	Window_MajiangMessage.prototype.setNameBoxWindow = function(nameBoxWindow) 
	{
    	this._nameBoxWindow = nameBoxWindow;
	};
	
	Window_MajiangMessage.prototype.setMessage = function(message,battler,wait = 90,audio) 
	{
		this.refresh();
    	this._message = message;
    	this._battler = (battler) ? battler : null;
    	if(this._battler)
    	{
    		this.loadBattlerFace();
    	}
    	this._audio = audio;
    	this.setWait(wait);
    	this.open();
    	if(this.useNameBox())
    	{
    		this._nameBoxWindow.setName(this.battlerNameText());
    		this._nameBoxWindow.start();
    	}
	};
	
	Window_MajiangMessage.prototype.useNameBox = function()
	{
		return (!!this._battler && $dataMajiangSystem.params.nameBox !== 0);
	};
	
	Window_MajiangMessage.prototype.battlerNameText = function()
	{
		let text = "";
		if($dataMajiangSystem.params.nameBox === 2)
		{
			text += this.menfengText(this._battler.menfeng()) + " ";
		}
		text += this._battler.name();
		return text;
	};
	
	Window_MajiangMessage.prototype.refresh = function()
	{
		this._drawn = false;
		
		this.contents.clear();
	};
	Window_MajiangMessage.prototype.drawMessageArray = function(rect)
	{
		const width = rect.width;
		const lines = this._message.length;
		const x = rect.x;
		let y = rect.y + ((rect.height - (this.lineHeight() * lines)) / 2 ) - this.itemPadding();
		
		for(let i = 0; i < lines ; i++)
		{
			const text = this._message[i];
			
			this.drawText(text,x,y,width,"center");
			y += this.lineHeight();
		}
	};
	
	Window_MajiangMessage.prototype.drawMessageText = function(rect) 
	{
		const textLines = this._message.split("\n");
		const lines = textLines.length;
		const maxTextWid = Math.max(...textLines.map(t => this.textSizeEx(t).width , this));
		
		const x = rect.x + ((rect.width - maxTextWid) / 2);
		
		const y = rect.y + ((rect.height - (this.lineHeight() * lines)) / 2 ) - this.itemPadding();
		
		this.drawTextEx(this._message, x, y, rect.width);
	};
	
	Window_MajiangMessage.prototype.drawMessage = function() 
	{
		const rect = this.baseTextRect();
		if(Array.isArray(this._message))
		{
			this.drawMessageArray(rect);
		}
		else
		{
			this.drawMessageText(rect);
		}
		
		
		this.drawBattlerFace(rect.x,rect.y);
		
		this._drawn = true;
		
	};
	Window_MajiangMessage.prototype.playVoiceLines = function() 
	{
		if(this._audio)
		{
			MajiangManager.playAudio(this._audio);
		};
	};
	
	
	Window_MajiangMessage.prototype.drawBattlerFace = function(x,y)
	{
		if(this._battler)
		{
			const actor = this._battler.actor();
        	
        	this.drawFace(actor.faceName(), actor.faceIndex(), x, y, ImageManager.faceWidth, ImageManager.faceWidth);
        }
    };
    	
    Window_MajiangMessage.prototype.loadBattlerFace = function() 
    {
    	this._faceBitmap = ImageManager.loadFace(this._battler.actor().faceName());
	};
	
	Window_MajiangMessage.prototype.faceReady = function()
	{
		if(!this._battler) return true;
		if(this._faceBitmap)
		{
			if(this._faceBitmap.isReady())
			{
				this._faceBitmap = null;
				return true;
			}
			else
			{
				return false;
			}
		}
    	
    };
	
	
	Window_MajiangMessage.prototype.setWait = function(wait) 
	{
		this._waitCount = wait;
	};
	Window_MajiangMessage.prototype.updateWait = function() 
	{
    	if (this._waitCount > 0) 
    	{
    	    this._waitCount -= MajiangManager.isFastForward() ? 3 : 1;
			if (this._waitCount < 0) 
    	    {
           		this._waitCount = 0;
        	}
    	    return true;
    	}
    	else 
    	{
    	    return false;
    	}
	};
	
	
	Window_MajiangMessage.prototype.update = function() 
	{	
		Window_MajiangBase.prototype.update.call(this);
		if(this.useNameBox())
		{
			this.synchronizeNameBox();
		}
		if(this.isOpen() && !this.isOpening() && !this.isClosing())
		{
			if(!this.updateWait())
			{
				if(this._nameBoxWindow)
				{
					this._nameBoxWindow.close();
				}
				this.close();
			}
			if(!this._drawn && this.faceReady())
			{
				this.drawMessage();
				this.playVoiceLines();
			}
		}
	};
	
	Window_MajiangMessage.prototype.synchronizeNameBox = function() 
	{
		if(this._nameBoxWindow)
		{
			this._nameBoxWindow.openness = this.openness;
		}
	};
	
	
	//------------
	
	Window_MajiangChoice.prototype.initialize = function(rect) 
	{
		this._rect = rect;
		this._items = [];
		Window_Command.prototype.initialize.call(this, new Rectangle());
    	
    	this.openness = 0;
    	this.deactivate();
    	this._background = 0;
    	this._canRepeat = false;
    	
    	
	};
	
	Window_MajiangChoice.prototype.start = function(items,methodName) 
	{
		this.setCondition();
    	this.updatePlacement();
    	//this.updateBackground();
    	
    	this.createContents();
    	this.refresh();
    	this.scrollTo(0, 0);
    	this.selectDefault(); 
    	this.open();
    	this.activate();
	};
	
	Window_MajiangChoice.prototype.setCondition = function()
	{
		const condition = MajiangManager.choiceCondition();
		this._items = condition.items;
		this._method = condition.methodName;
	};
	
	Window_MajiangChoice.prototype.selectDefault = function() 
	{
    	this.select(this._items.length);
	};
	
	Window_MajiangChoice.prototype.makeCommandList = function() 
	{
		if(this._items)
		{
    		for (const item of this._items) 
    		{
    		    this.addCommand(item.name, "choice");
    		}
    		this.addCommand($dataMajiangSystem.text.cancel, "cancel");
    	}
    	
	};
	
	Window_MajiangChoice.prototype.item = function()
	{
		return this._items[this.index()]?.item || null;
	};
	
	
	
	
	
	Window_MajiangChoice.prototype.updatePlacement = function() 
	{
    	this.y = this.windowY();
    	this.x = this._rect.x;
    	this.height = this.windowHeight();
    	this.width = this._rect.width;
	};
	
	Window_MajiangChoice.prototype.windowHeight = function() 
	{
		return this.fittingHeight(this.numVisibleRows());
	};
	
	Window_MajiangChoice.prototype.numVisibleRows = function() 
	{
		return this._items.length + 1;
	};
	
	Window_MajiangChoice.prototype.classic = function()
	{
		return $dataMajiangSystem.params.classicChoice;
	}
	
	
	Window_MajiangChoice.prototype.drawItem = function(index)
	{
		const item = this._items[index];
		
		if(this.classic()
			|| !item
			|| !["chi","peng","daminggang", "jiagang", "angang"].includes(item.item?.kind)
			|| !this.drawMajiangPaiCanvas)
		{
			Window_Command.prototype.drawItem.apply(this,arguments);
			return;
		}
		const rect = this.itemLineRect(index);
		const paiHeight = this.lineHeight();
		const paiWidth = Math.floor(paiHeight * 0.75);
		const maxPaiWidth = paiWidth * item?.paizi.length;
		const padding = this.itemPadding();
		const textWidth = rect.width - (padding + maxPaiWidth);
		const paiX = rect.x + (rect.width - maxPaiWidth);
		const align = this.itemTextAlign();
		this.resetTextColor();
		this.changePaintOpacity(this.isCommandEnabled(index));
		this.drawText(this.commandName(index), rect.x, rect.y, textWidth, align);
		
		const paizi = this.createPaicodeEscapeCharacter(item.paizi.map(p => p.exportCode()));
		this.drawTextEx(paizi, paiX , rect.y, maxPaiWidth);
	};
	
	
	
	Window_MajiangChoice.prototype.createPaicodeEscapeCharacter = function(codeArray)
	{
		return "\x1bMJP[" + codeArray.join(",") + "]";
	};
	
	
	Window_MajiangChoice.prototype.windowY = function() 
	{
    	return this._rect.bottom - this.windowHeight();
	};
	
	Window_MajiangChoice.prototype.callOkHandler = function() 
	{
    	MajiangManager[this._method](this.item());
    	this.selectPai(null);
    	this.close();
	};
	
	Window_MajiangChoice.prototype.callCancelHandler = function() 
	{
   		MajiangManager[this._method](null);
   		this.selectPai(null);
   		this.close();
	};
	
	Window_MajiangChoice.prototype.select = function(index) 
	{
    	Window_Command.prototype.select.call(this, index);
    	this.selectPai(this._items[index]);
	};
	
	
	Window_MajiangChoice.prototype.selectPai = function(item) 
	{
		$gameMajiangPaishan.requestResetSelectionEffect();
		for(const pai of $gameMajiangPaishan.allData())
		{
			if(item?.paizi && item.paizi.includes(pai))
			{
				pai.select();
			}
			else
			{
				pai.deselect();
			}
		}
	};
	
	Window_MajiangChoice.prototype.isCancelEnabled = function() 
	{
    	return true;
	};
	
	//------------------
	
	
	Window_MajiangResultPoint.prototype.initialize = function(rect) 
	{
		Window_MajiangBase.prototype.initialize.call(this, rect);
		this._battler = null;
	};
	Window_MajiangResultPoint.prototype.setBattler = function(battler) 
	{
		this._battler = battler;
		this.refresh();
		
	};
	
	Window_MajiangResultPoint.prototype.refresh = function(battler) 
	{
		this.contents.clear();
		if(this._battler)
		{
			this.draw();
		}
	};
	
	Window_MajiangResultPoint.prototype.draw = function() 
	{
		const rect = new Rectangle(0, 0, this.innerWidth, this.innerHeight);
		const faceWidth = rect.height -  this.lineHeight();
		const faceY = rect.y + this.lineHeight();
		const pointX = rect.x + faceWidth + this.itemPadding();
		const pointWidth = rect.width - pointX;
		this.drawBattlerName(this._battler, rect.x,rect.y,rect.width);
		
		this.drawMajiangFace(this._battler,rect.x,faceY,faceWidth,faceWidth);
		this.drawPoint(this._battler,pointX,faceY,pointWidth);
	};
	
	Window_MajiangResultPoint.prototype.drawPoint = function(battler,x,y,width) 
	{
		const data = battler.pointData();
		const addedValue = data.add;
		const currentValue = data.current;
		const pointText = $dataMajiangSystem.text.point;
		const text1 = (addedValue > 0 ? "+" : "") + this.pointValue(addedValue);
		const text2 = pointText.format(this.pointValue(currentValue));
		if(addedValue !== 0)
		{
			this.changeTextColor(ColorManager.paramchangeTextColor(addedValue));
			
			this.drawText(text1, x, y, width,"right");
		}
		this.resetTextColor();
		if(currentValue < 0)
		{
			this.changeTextColor(ColorManager.paramchangeTextColor(currentValue));
		}
		this.drawText(text2, x, y + this.lineHeight(), width,"right");
		this.resetTextColor();
	};
	
	//------------------
	
	Window_MajiangResultTehai.prototype.initialize = function(rect) 
	{
		
		Window_MajiangBase.prototype.initialize.call(this, rect);
		this._battler = null;
	};
	
	Window_MajiangResultTehai.prototype.setBattler = function(battler,hele) 
	{
		this._battler = battler;
		this._hele = hele;
		this.refresh();
		
	};
	
	Window_MajiangResultTehai.prototype.refresh = function() 
	{
		this.destroyMajiangpai();
		this.contents.clear();
		if(this._battler)
		{
			this.draw();
		}
		
	};
	Window_MajiangResultTehai.prototype.paiHeight = function() 
	{
		return this.lineHeight();
	};
	Window_MajiangResultTehai.prototype.paiWidth = function() 
	{
		return this.paiHeight() * 0.75;
	};
	
	Window_MajiangResultTehai.prototype.draw = function() 
	{
		const rect = this.baseTextRect();
		const paiHeight = this.lineHeight()
		
		const lineHeight = this.lineHeight();
		
		const faceWidth = Math.min(ImageManager.faceWidth,(rect.height - lineHeight));
		const faceY = rect.y + lineHeight + ((this.innerHeight - lineHeight - faceWidth) / 2);
		const tehaiX = rect.x + faceWidth + (this.itemPadding() * 2);
		const tehaiY = Math.max( faceY , ((rect.bottom - (this.paiHeight() * 2)) / 2));
		const tehaiWidth = this.innerWidth - tehaiX;
		
		const paiY = this.innerHeight - this.lineHeight();
		const paiX = tehaiX;
		
		
		this.drawStatus(rect.x , rect.y , rect.width);
		
		this.drawMajiangFace(this._battler,rect.x,faceY,faceWidth,faceWidth);
		if(!this._hele && this._battler.isNagashiMangan())
		{
			this.drawPaizi(tehaiX,tehaiY,this._battler.he(),this.resultPaiHeight(),0,20,2);
		}
		else
		{
			this.drawTehai(tehaiX,tehaiY,tehaiWidth,this._battler,this.resultPaiHeight());
		}
		if(this._hele)
		{
			this.drawPaiStatus(paiX,paiY);
		}
	};
		
	Window_MajiangResultTehai.prototype.resultPaiHeight = function()
	{
		const width = $dataMajiangSystem.params.resultPaiWidth;
		
		return ((width) ? (width / 0.75) : this.paiHeight());
	};
	
	Window_MajiangResultTehai.prototype.drawStatus = function(x,y,width) 
	{
		const nameWidth = Math.floor(width / 2);
		this.drawBattlerName(this._battler, x , y , nameWidth);
		
		const heleX = x + nameWidth + this.itemPadding();
		
		if(this._hele)
		{
			const isTianhe = this._battler.isTianhe();
			let heleTypeText;
			let helePai;
			if(isTianhe)
			{
				heleTypeText = $gameMajiangSystem.yakuData["tianhe"].text;
			}
			else
			{
				const helePaiId = this._battler.tehai().find(p => p.isHelePai()).paiId();
				helePai = $gameMajiangPaishan.makeDummyPaiById(helePaiId);
				
				heleTypeText = ((this._battler.isRong()) ? $dataMajiangSystem.text.rong : $dataMajiangSystem.text.zimo) + " : ";
			}
			const heleTextWidth = this.textWidth(heleTypeText);
			this.drawText(heleTypeText,heleX,y,heleTextWidth);
			if(!isTianhe)
			{
				this.drawPaizi(heleX + heleTextWidth,y,[helePai],this.paiHeight());
			}
			const changStatusWidth = Math.floor(width / 3.75);
			const changStatusX = (x + width) - changStatusWidth;
			this.drawChangStatus(changStatusX,y,changStatusWidth);
		}
		else if(this._battler.isNagashiMangan())
		{
			this.drawText($dataMajiangSystem.text.nagashiMangan,heleX,y,this._innerWidth);
			
		}
		else if(this._battler.isTingpai())
		{
			this.drawText($dataMajiangSystem.text.tingpai,heleX,y,this._innerWidth);
		}
		else
		{
			this.drawText($dataMajiangSystem.text.noting,heleX,y,this._innerWidth);
		}
		
	};
	
	Window_MajiangResultTehai.prototype.drawPaiStatus = function(x,y) 
	{
		let cx = x;
		
		if($gameMajiangSystem.gamerule.dora)
		{
			const doraText = $dataMajiangSystem.text.dora + " : ";
			const doraTextWidth = this.textWidth(doraText);
			this.drawText(doraText,cx,y,doraTextWidth)
			cx += doraTextWidth;
			this.drawDora(cx,y);
			
			if(this._battler.isLizhi())
			{
				cx += this.doraWidth() + this.itemPadding();
				
				const uradoraText = $dataMajiangSystem.text.uradora + " : ";
				const uradoraTextWidth = this.textWidth(uradoraText);
				this.drawText(uradoraText,cx,y,uradoraTextWidth)
				cx += uradoraTextWidth;
				
				this.drawUradora(cx,y);
			}
		}
	};
	Window_MajiangResultTehai.prototype.doraWidth = function() 
	{
		return this.paiWidth() * 5;
	};
	
	Window_MajiangResultTehai.prototype.drawDora = function(x, y) 
	{
		const xianwu = $dataMajiangSystem.params.echoDora;
		const paizi = (xianwu) ? $gameMajiangPaishan.dora() : $gameMajiangPaishan.echoDora();
		
		this.drawPaizi(x,y,paizi,this.paiHeight());
	};
	Window_MajiangResultTehai.prototype.drawUradora = function(x, y) 
	{
		const xianwu = $dataMajiangSystem.params.echoDora;
		const paizi = (xianwu) ? $gameMajiangPaishan.uradora() : $gameMajiangPaishan.echoUradora();
		
		this.drawPaizi(x,y,paizi,this.paiHeight());
	};
	
	
	//-----------------------------------
	
	Window_MajiangResultYaku.prototype.initialize = function(rect) 
	{
		
		Window_MajiangBase.prototype.initialize.call(this, rect);
		this._battler = null;
	};
	
	Window_MajiangResultYaku.prototype.setBattler = function(battler) 
	{
		this._battler = battler;
		this.refresh();
		
	};
	Window_MajiangResultYaku.prototype.refresh = function() 
	{
		this.contents.clear();
		if(this._battler)
		{
			this.draw();
		}
		
	};
	
	Window_MajiangResultYaku.prototype.yakuMaxCols = function() 
	{
		return 6;
	};
	
	
	Window_MajiangResultYaku.prototype.draw = function() 
	{
		const rect = this.baseTextRect();
		
		this.drawAllYaku(rect.x,rect.y,rect.width);
		
		const horzY = rect.bottom - this.lineHeight() * 1.5;
		const pointY = rect.bottom - this.lineHeight() * 1;
		
		this.drawHorzLine(rect.x,horzY);
		
		this.drawPoint(rect.x,pointY,rect.width);
		
	};
	
	
		
	Window_MajiangResultYaku.prototype.drawHorzLine = function(x,y) 
	{
	    const padding = this.itemPadding();
	    x += padding / 2;
	    const width = this.innerWidth - padding * 2;
	    this.drawRect(x, y, width, 5);
	};
	
	Window_MajiangResultYaku.prototype.drawPoint = function(x,y,width) 
	{
		const heleResult = this._battler.heleResult();
		const yakuman = heleResult.yaku.yakuman;
		const pointData = heleResult.point;
		let text1 = "";
		let text2 = "";
		
		if(!yakuman)
		{
			text1 += this.textFanfu(pointData);
		}
		
		if(pointData.mangan)
		{
			if(yakuman)
			{
				text2 += this.textYakuman(pointData.yakuman);
			}
			else
			{
				text2 += this.textMangan(pointData.mangan);
			}
		}
		text2 += " ";
		
		text2 +=  $dataMajiangSystem.text.point.format(this.pointValue(pointData.gainPoint));
		this.drawText(text1,x,y,width,);
		this.drawText(text2,x,y,width,"right");
	};
	
	Window_MajiangResultYaku.prototype.textMangan = function(mangan) 
	{
		return $dataMajiangSystem.text[mangan];
	};
	
	Window_MajiangResultYaku.prototype.textYakuman = function(yakuman) 
	{
		
		switch(yakuman)
		{
			case 1 : return $dataMajiangSystem.text.yakuman;
			case 2 : return $dataMajiangSystem.text.doubleYakuman;
			case 3 : return $dataMajiangSystem.text.tripleYakuman;
			default : return $dataMajiangSystem.text.nthYakuman.format(MajiangManager.textShuzi(yakuman));
		}
	};
	
	Window_MajiangResultYaku.prototype.textFanfu = function(pointData) 
	{
		let text = "";
		if(!$gameMajiangSystem.gamerule.funashi && Number.isInteger(pointData.fu))
		{
			text += $dataMajiangSystem.text.fu.format(pointData.fu);
			text += " ";
		}
		
		if(Number.isInteger(pointData.fan))
		{
			text += $dataMajiangSystem.text.fan.format(pointData.fan);
		}
		return text;
	};
	
	
	
	
	Window_MajiangResultYaku.prototype.drawAllYaku = function(x,y,width) 
	{
		const heleResult = this._battler.heleResult()
		
		const yakuResult = [...heleResult.yaku.yakuResult].sort((a,b) => b.priority - a.priority);
		const needsNumber = !(heleResult.yaku.yakuman);
		let maxCols = this.yakuMaxCols();
		if(yakuResult.length > 12)
		{
			maxCols = Math.ceil(yakuResult.length / 2)
		}
		yakuResult.forEach(function ( yaku, i )
		{
			const yakuWidth = width / 2;
			const yakuX = x + ((i >= maxCols) ? yakuWidth : 0 );
			const yakuY = y + ((i % maxCols) * this.lineHeight());
			this.drawYaku(yakuX,yakuY,yakuWidth , yaku , needsNumber);
		},this);
	};
	
	Window_MajiangResultYaku.prototype.drawYaku = function(x,y,width,yaku,needsNumber) 
	{
		width = width -this.itemPadding();
		let nameWidth = width ;
		if(needsNumber)
		{
			this.drawFanNumber(yaku.fan, x, y, width);
			nameWidth -= this.textWidth($dataMajiangSystem.text.fan.format("00"));
		}
		
		const yakuText = this.yakuText(yaku.name)
		this.drawText(yakuText, x, y, nameWidth);
		
	};
	Window_MajiangResultYaku.prototype.yakuText = function(yakuName)
	{
		if(yakuName === "dora")
		{
			return $dataMajiangSystem.text.dora;
		}
		return $gameMajiangSystem.yakuData[yakuName].text;
	}
	
	Window_MajiangResultYaku.prototype.drawFanNumber = function(fan, x, y, width) 
	{
        this.drawText($dataMajiangSystem.text.fan.format(fan), x, y, width, "right");
    };
    
    //-----------------------------------
    
    Window_MajiangResultFinalPoint.prototype.initialize = function(rect) 
	{
		
		Window_MajiangBase.prototype.initialize.call(this, rect);
		this._battler = null;
	};
	
	Window_MajiangResultFinalPoint.prototype.setFinalResult = function(finalResult) 
	{
		this._finalResult = finalResult;
		
		this.refresh();
		
	};
	
	Window_MajiangResultFinalPoint.prototype.refresh = function() 
	{
		this.contents.clear();
		if(this._finalResult)
		{
			this.draw();
		}
		
	};
	Window_MajiangResultFinalPoint.prototype.draw = function() 
	{
		const rect = this.baseTextRect();
		
		const battler = $gameMajiangBattlers.battler(this._finalResult.position);
		const faceWidth = rect.height;
		const rankWidth = Math.floor(rect.width / 12);
		const faceX = rect.x + rankWidth + this.itemPadding();
		
		const rankY = (rect.height - this.lineHeight()) / 2;
		
		const pointWidth = Math.floor(rect.width / 3);
		
		const pointX = rect.right - pointWidth;
		
		const nameX = faceX + faceWidth + this.itemPadding();
		
		const nameWidth = (pointX -  nameX );
		
		
		
		this.drawRanking(rect.x , rankY , rankWidth);
		
		this.drawText(battler.name(), nameX , rankY , nameWidth - this.itemPadding());
		
		this.drawMajiangFace(battler,faceX,rect.y,faceWidth,faceWidth);
		this.makeFontBigger();
		this.drawPoint(pointX,rankY,pointWidth);
		this.resetFontSettings();
		
	};
	Window_MajiangResultFinalPoint.prototype.drawRanking = function(x,y,width) 
	{
		const rankText = $dataMajiangSystem.text.ranking.format(this._finalResult.ranking);
		
		this.drawText(rankText, x , y , width);
	}
	
	
	Window_MajiangResultFinalPoint.prototype.drawPoint = function(x,y,width) 
	{
		const point = this._finalResult.finalPoint;
		
		const text = (this.pointValue(point));
		
		this.drawText(text, x, y, width,"center");
		
	};
	
	
    
  

	//-----------------------------------
	
	Window_MajiangEndMenu.prototype.initialize = function(rect) 
	{
    	Window_Command.prototype.initialize.call(this, rect);
    	this.openness = 0;
    	//this.open();
	};

	Window_MajiangEndMenu.prototype.makeCommandList = function() 
	{
    	this.addCommand($dataMajiangSystem.text.menuGameEnd, "gameEnd");
    	this.addCommand($dataMajiangSystem.text.menuContinue, "cancel");
	};
	
	
	
	
	//---------------------
	
	
	
	Window_MajiangOptions.prototype.initialize = function(rect) 
	{
		this.setData();
    	Window_Command.prototype.initialize.call(this, rect);
    	
	};
	
	Window_MajiangOptions.prototype.setData = function() 
	{
		this._data = {};
		this._selectDisabled = {};
	   	for(const key in $dataMajiangSystem.gamerule)
	   	{
	   		const value = $gameMajiangSystem.queryGamerule2(key);
	   		if($gameMajiangSystem.gameruleOperable(key))
	   		{
	   			this._data[key] = $gameMajiangSystem.gamerule[key];
		   	}
		   	this._selectDisabled[key] = $gameMajiangSystem.gameruleSelectDisabled(key);
		}
	};
	
	Window_MajiangOptions.prototype.save = function() 
	{
		const ret = {};
		for(const key in this._data)
	   	{
	   		if(this._data[key] !== void 0 && !this._selectDisabled[key])
	   		{
	   			$gameMajiangSystem.loadSystemData("gamerule")[key] = this._data[key] + 10;
		   	}
		   	
	   	}
	};
	
	Window_MajiangOptions.prototype.makeCommandList = function() 
	{
	    this.addOptions();
	  
	};
	
	Window_MajiangOptions.prototype.addOptions = function() 
	{
		for(const key in this._data)
		{
			const text = $dataMajiangSystem.text["option_" + key];
			const enabled = !	this._selectDisabled[key];
    		this.addCommand(text, key,enabled);
    	}
	};
	
	
	
	Window_MajiangOptions.prototype.drawItem = function(index) 
	{
    	const title = this.commandName(index);
    	const status = this.statusText(index);
    	const rect = this.itemLineRect(index);
    	const statusWidth = this.statusWidth();
    	const titleWidth = rect.width - statusWidth;
    	this.resetTextColor();
    	this.changePaintOpacity(this.isCommandEnabled(index));
    	this.drawText(title, rect.x, rect.y, titleWidth, "left");
    	this.drawText(status, rect.x + titleWidth, rect.y, statusWidth, "right");
	};
	
	Window_MajiangOptions.prototype.statusWidth = function() 
	{
	    return 120;
	};
	
	Window_MajiangOptions.prototype.statusText = function(index) 
	{
    	const key = this.commandSymbol(index);
    	const value = this.getConfigValue(key);
    	
    	
    	const textKeys = $dataMajiangSystem.gameruleTable[key].statusText;
    	const textKey = textKeys[value];
    	return $dataMajiangSystem.text[textKey];
	};
	
	
	
	
	
	Window_MajiangOptions.prototype.processOk = function() 
	{
    	const index = this.index();
    	const key = this.commandSymbol(index);
    	
    	if(this.isCurrentItemEnabled())
    	{
    		
    		this.changeValue(key, this.newValueLoop(key));
	    }
	    else
	    {
	    	this.playBuzzerSound();
		}
    	
    	
	};
	
	Window_MajiangOptions.prototype.cursorRight = function() 
	{
	    const index = this.index();
	    const key = this.commandSymbol(index);
	    this.changeValue(key, this.newValue(key,true));
	   
	};
	
	Window_MajiangOptions.prototype.cursorLeft = function() 
	{
	    const index = this.index();
	    const key = this.commandSymbol(index);
	    this.changeValue(key, this.newValue(key,false));
	};
	
	Window_MajiangOptions.prototype.newValue = function(key, next) 
	{
		const lastValue = this.getConfigValue(key);
    	const maxValue = $dataMajiangSystem.gameruleTable[key].statusText.length -1;
    	
    	const value = (lastValue + ((next) ? 1 : - 1)).clamp(0,maxValue);
    	
    	return value;
	}
		
	Window_MajiangOptions.prototype.newValueLoop = function(key) 
	{
		const lastValue = this.getConfigValue(key);
    	const length = $dataMajiangSystem.gameruleTable[key].statusText.length;
    	
    	const value = (lastValue + 1) % length;
    	
    	return value;
	}
	
	Window_MajiangOptions.prototype.changeValue = function(key, value) 
	{
		const lastValue = this.getConfigValue(key);
    	
    	if (this.isCurrentItemEnabled() && (lastValue !== value))
    	{
    	    this._data[key] = value;
    	    this.redrawItem(this.findSymbol(key));
    	    this.playCursorSound();
    	}
	};
	
	
	Window_MajiangOptions.prototype.getConfigValue = function(symbol) 
	{
    	return this._data[symbol];
	};




})();









