//=============================================================================
// 第1版 - 初版
// 第2版 - 中断時のスイッチ操作をMajiangManagerで行うように変更
// 第6版 - MajiangManagerからの強制終了リクエストに対応
// 第7版 - ステータスウィンドウのみを非表示にするコマンドに対応
// 第8版 - 麻雀牌スプライトの表示方式を変更
//          雀卓マージン設定に対応
//          自家副露エリアのオフセット設定に対応
// 第9版 - 終了後のシーン移動処理を変更
//          河の表示処理を変更
// 第10版 - 二人麻雀に対応
// 第11版 - 背景画像を中央に配置するように変更
//
// 
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 麻雀 (シーン)
 * @author 
 * @base AP1S_MajiangCore
 * @orderAfter AP1S_MajiangCore
 *
 * @help
 * 
 * ミニゲーム 麻雀
 * 
 * 詳細な使用方法は 同梱の説明書をご覧ください
 * 
 * 
 * 
 */
 

function Scene_MajiangOptions() 
{
    this.initialize(...arguments);
}

Scene_MajiangOptions.prototype = Object.create(Scene_MenuBase.prototype);
Scene_MajiangOptions.prototype.constructor = Scene_MajiangOptions;

function Scene_MajiangBattle() 
{
    this.initialize(...arguments);
}

Scene_MajiangBattle.prototype = Object.create(Scene_Message.prototype);
Scene_MajiangBattle.prototype.constructor = Scene_MajiangBattle;

function Scene_MajiangResult() 
{
    this.initialize(...arguments);
}

Scene_MajiangResult.prototype = Object.create(Scene_Base.prototype);
Scene_MajiangResult.prototype.constructor = Scene_MajiangResult;


(function() 
{
	"use strict";
	
	const P_name = decodeURIComponent(document.currentScript.src).match(/([^\/]+)\.js$/)[1]; //プラグイン名
	
	Scene_MajiangOptions.prototype.initialize = function()
	{
		Scene_MenuBase.prototype.initialize.call(this);
	};
	
	Scene_MajiangOptions.prototype.create = function() 
	{
    	Scene_MenuBase.prototype.create.call(this);
    	this.createOptionsWindow();
	};
	
	Scene_MajiangOptions.prototype.terminate = function() 
	{
    	Scene_MenuBase.prototype.terminate.call(this);
    	this._optionsWindow.save();
	};
	
	
	
	
	
	
	Scene_MajiangOptions.prototype.createOptionsWindow = function() 
	{
    	const rect = this.optionsWindowRect();
    	this._optionsWindow = new Window_MajiangOptions(rect);
    	this._optionsWindow.setHandler("cancel", this.popScene.bind(this));
    	this.addWindow(this._optionsWindow);
	};
	
	Scene_MajiangOptions.prototype.optionsWindowRect = function() 
	{
    	const n = Math.min(this.maxCommands(), this.maxVisibleCommands());
    	const ww = 400;
    	const wh = this.calcWindowHeight(n, true);
    	const wx = (Graphics.boxWidth - ww) / 2;
    	const wy = (Graphics.boxHeight - wh) / 2;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangOptions.prototype.maxCommands = function() 
	{
		let count = 0;
		
	    for(const key in $dataMajiangSystem.gamerule)
	    {
	    	
	    	if($gameMajiangSystem.queryGamerule2(key) >= 10)
	    	{
	    		count++;
		    }
		}
		
	    return count;
	};
	
	Scene_MajiangOptions.prototype.maxVisibleCommands = function() 
	{
    	return 12;
	};
	
	
	
	
	
	
	
	Scene_MajiangBattle.prototype.initialize = function()
	{
		Scene_Message.prototype.initialize.call(this);
		//
		
		this.setInitialFade();
	};
	
	Scene_MajiangBattle.prototype.create = function() 
	{
		Scene_Message.prototype.create.call(this);
    	//
    	
    	
    	this.createPaiLayer();
    	this.createWindowLayer();
    	
    	this.createButtons();
    	
    	this.createZhuo();
    	
    	
    	this.createAllBattlerAreas();
    	
    	this.createAllMajiangWindows();
    	Scene_Message.prototype.createAllWindows.call(this);
    	
    	
	};
	/*
	Scene_MajiangBattle.prototype.createBackground = function()
	{
		Scene_MajiangResult.prototype.createBackground.call(this);
	};
	*/
	Scene_MajiangBattle.prototype.setInitialFade = function() 
	{
		this._fadeOpacity = 255;
		this.updateColorFilter();
	};
	
	Scene_MajiangBattle.prototype.calcWindowHeight = function(numLines, selectable) 
	{
		if(!$dataMajiangSystem.params.lineHeight)
		{
			return Scene_Message.prototype.calcWindowHeight.call(this,numLines,selectable);
		}
		if (selectable) 
		{
			return Window_Selectable.prototype.fittingHeight(numLines);
		}
		else 
		{
			return Window_MajiangBase.prototype.fittingHeight(numLines);
		}
	};
	
	
	
	Scene_MajiangBattle.prototype.start = function()
	{
		Scene_Message.prototype.start.call(this);
		//
		
	};
	
	Scene_MajiangBattle.prototype.createButtons = function()
	{
		if (ConfigManager.touchUI) 
		{
        	this.createCancelButton();
    	}
	};
	
	Scene_MajiangBattle.prototype.createPaiLayer = function() 
	{
    	this._paiLayer = new Spriteset_MajiangPaiLayer();
    	
    	this.addChild(this._paiLayer);
	};
	
	
	Scene_MajiangBattle.prototype.createCancelButton = function()
	{
		this._cancelButton = new Sprite_Button("cancel");
    	this._cancelButton.x = Graphics.boxWidth - this._cancelButton.width - 4;
    	this._cancelButton.y = this.buttonY();
    	this.addWindow(this._cancelButton);
	};
	
	
	Scene_MajiangBattle.prototype.createAllMajiangWindows = function()
	{
		this._echoWindows = {};
    	this.createStatusWindow();
    	
		this.createZijiaStatusWindow();
		if(MajiangManager.checkPosition(1))
		{
			this.createShimojiaStatusWindow();
		}
		if(MajiangManager.checkPosition(2))
		{
			this.createDuimianStatusWindow();
		}
		if(MajiangManager.checkPosition(3))
		{
			this.createKamijiaStatusWindow();
		}
		this.createMajiangMessageWindow();
		
		this.createMajiangNameBoxWindow();
		
		
		
		this.createChoiceWindow();
		this.createFuritenWindow();
		this.createTingpaiMachiWindow();
		this.createGameEndMenuWindow();
		
		this.associateMajiangWindows();
		
		
	};
	
	Scene_MajiangBattle.prototype.createAllBattlerAreas = function()
	{
		this.createZijiaAreas();
		
		if(MajiangManager.checkPosition(1))
		{
			this.createShimojiaAreas();
		}
		if(MajiangManager.checkPosition(2))
		{
			this.createDuimianAreas();
		}
		if(MajiangManager.checkPosition(3))
		{
			this.createKamijiaAreas();
		}
	};
	
	Scene_MajiangBattle.prototype.createStatusWindow = function()
	{
    	const rect = this.statusWindowRect();
    	const statusWindow = new Window_MajiangStatus(rect,0);
    	
    	this._echoWindows.status = statusWindow;
    	this.addWindow(statusWindow);
	};
	
	Scene_MajiangBattle.prototype.statusWindowRect = function()
	{
		const ww = Math.floor(this.zhuo.width / 3);
    	const wh = this.calcWindowHeight(1,false)
    	 + Window_Base.prototype.itemPadding()
    	 + $dataMajiangSystem.tajiaPaiHeight;
    	
    	
    	let wx = Math.floor(this.zhuo.x + (this.zhuo.width - ww) / 2);
    	wx = Math.floor(wx / 2) * 2;
    	const wy = Math.floor(this.zhuo.y + (this.zhuo.height - wh) / 2);
    	return new Rectangle(wx, wy, ww, wh);
    	
	};
	
	
	
	Scene_MajiangBattle.prototype.createMajiangMessageWindow = function() 
	{
		const rect = this.messageWindowRect();
    	this._majiangMessageWindow = new Window_MajiangMessage(rect);
    	MajiangManager.setMessageWindow(this._majiangMessageWindow);
    	this.addWindow(this._majiangMessageWindow);
    	
    	
	};
	
	
	
	
	
	Scene_MajiangBattle.prototype.messageWindowRect = function() 
	{
    	const ww = this.majiangBoxWidth();
    	const wh = this.calcWindowHeight(4, false) + 8;
    	const wx = (Graphics.boxWidth - ww) / 2;
    	const wy = (Graphics.boxHeight - wh ) / 2;
    	return new Rectangle(wx, wy, ww, wh);
	};
	Scene_MajiangBattle.prototype.createMajiangNameBoxWindow = function() 
	{
    	this._majiangNameBoxWindow = new Window_NameBox();
    	this.addWindow(this._majiangNameBoxWindow);
	};
	
	Scene_MajiangBattle.prototype.associateMajiangWindows = function() 
	{
    	const messageWindow = this._majiangMessageWindow;
    	messageWindow.setNameBoxWindow(this._majiangNameBoxWindow);
    	this._majiangNameBoxWindow.setMessageWindow(messageWindow);
	};

	
	
	
	Scene_MajiangBattle.prototype.createChoiceWindow = function()
	{
		const rect = this.choiceWindowRect();
    	this._choiceWindow = new Window_MajiangChoice(rect);
    	
    	this.addWindow(this._choiceWindow);
	};
	
	Scene_MajiangBattle.prototype.choiceWindowRect = function()
	{
		const ww = this.mainCommandWidth();
    	const wh = 0;
    	const wx = this._zijiaTehaiWindow.x + this._zijiaTehaiWindow.width - ww;
    	
    	const wy = this._zijiaTehaiWindow.y;
    	return new Rectangle(wx, wy, ww, wh);
		
	};
	Scene_MajiangBattle.prototype.createFuritenWindow = function()
	{
		const rect = this.furitenWindowRect();
    	const furitenWindow = new Window_MajiangFuriten(rect);
    	furitenWindow.setBattler($gameMajiangBattlers.zijia());
    	this._echoWindows.furiten = furitenWindow;
    	this.addWindow(furitenWindow);
	};
	
	Scene_MajiangBattle.prototype.furitenWindowRect = function()
	{
		//const ww = this.mainCommandWidth();
    	//const wh = this.calcWindowHeight(1,false);
    	const ww = 0;
    	const wh = this.battlerStatusWindowHeight();
    	//const wx = this._zijiaTehaiWindow.x;
    	//const wy = this._zijiaTehaiWindow.y - wh;
    	
    	const wx = this._echoWindows.zijiaStatus.x;
    	const wy = this._echoWindows.zijiaStatus.y;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangBattle.prototype.createTingpaiMachiWindow = function()
	{
		const rect = this.tingpaiMachiWindowRect();
    	const tingpaiMachiWindow = new Window_MajiangTingpaiMachi(rect);
    	tingpaiMachiWindow.setBattler($gameMajiangBattlers.zijia());
    	this._echoWindows.tingpaiMachi = tingpaiMachiWindow;
    	this._zijiaTehaiWindow.setTingpaiMachiWindow(tingpaiMachiWindow);
    	this.addWindow(tingpaiMachiWindow);
	};
	
	Scene_MajiangBattle.prototype.tingpaiMachiWindowRect = function()
	{
		const ww = 0;
    	const wh = 0;
    	const wx = this._zijiaTehaiWindow.x;
    	const wy = this._zijiaTehaiWindow.y;
    	return new Rectangle(wx, wy, ww, wh);
		
	};
	
	Scene_MajiangBattle.prototype.createGameEndMenuWindow = function() 
	{
	    const rect = this.gameEndMenuWindowRect();
	    this._gameEndMenuWindow = new Window_MajiangEndMenu(rect);
	    this._gameEndMenuWindow.setHandler("gameEnd", this.gameEnd.bind(this));
	    this._gameEndMenuWindow.setHandler("cancel", this.cancelGameEndMenu.bind(this));
	   
	    this._gameEndMenuWindow.deactivate();
	    this.addWindow(this._gameEndMenuWindow);
	};
	
	Scene_MajiangBattle.prototype.gameEndMenuWindowRect = function() 
	{
    	const ww = this.mainCommandWidth();
    	const wh = this.calcWindowHeight(2, true);
    	const wx = (Graphics.boxWidth - ww) / 2;
    	const wy = (Graphics.boxHeight - wh) / 2;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	Scene_MajiangBattle.prototype.createZijiaStatusWindow = function()
	{
		
    	const rect = this.zijiaStatusWindowRect();
    	const statusWindow = new Window_MajiangBattlerStatus(rect);
    	statusWindow.setBattler($gameMajiangBattlers.zijia() , 0);
    	
    	this.addWindow(statusWindow);
    	this._echoWindows.zijiaStatus = statusWindow;
	};
	Scene_MajiangBattle.prototype.createShimojiaStatusWindow = function()
	{
		
    	const rect = this.shimojiaStatusWindowRect();
    	const statusWindow = new Window_MajiangBattlerStatus(rect);
    	statusWindow.setBattler($gameMajiangBattlers.shimojia() , 1);
    	
    	this.addWindow(statusWindow);
    	this._echoWindows.shimojiaStatus = statusWindow;
	};
	Scene_MajiangBattle.prototype.createDuimianStatusWindow = function()
	{
		
    	const rect = this.duimianStatusWindowRect();
    	const statusWindow = new Window_MajiangBattlerStatus(rect);
    	statusWindow.setBattler($gameMajiangBattlers.duimian() , 2);
    	
    	this.addWindow(statusWindow);
    	this._echoWindows.duimianStatus = statusWindow;
	};
	Scene_MajiangBattle.prototype.createKamijiaStatusWindow = function()
	{
		
    	const rect = this.kamijiaStatusWindowRect();
    	const statusWindow = new Window_MajiangBattlerStatus(rect);
    	statusWindow.setBattler($gameMajiangBattlers.kamijia() , 3);
    	
    	this.addWindow(statusWindow);
    	this._echoWindows.kamijiaStatus = statusWindow;
	};
	
	Scene_MajiangBattle.prototype.battlerStatusWindowHeight = function()
	{
		return Math.min(this.calcWindowHeight(1,false) , this.zhuoPadding());
    	
	};
	Scene_MajiangBattle.prototype.battlerStatusWindowWidth = function()
	{
		return Math.floor(this.majiangBoxWidth() / 2);
	};
	
	
	Scene_MajiangBattle.prototype.zijiaStatusWindowRect = function()
	{
		
		const ww = this.battlerStatusWindowWidth();
    	const wh = this.battlerStatusWindowHeight();
    	
    	const wx = Math.floor((Graphics.boxWidth - ww) / 2);
    	const wy = this.zhuo.bottom ;// wh;
    	return new Rectangle(wx, wy, ww, wh);
    	
	};
	
	Scene_MajiangBattle.prototype.shimojiaStatusWindowRect = function()
	{
		const ww = this.battlerStatusWindowHeight();
    	const wh = this.battlerStatusWindowWidth();
    	
    	const wx = this.zhuo.right + this.zhuoPadding();
    	const wy = Math.floor((Graphics.boxHeight - wh) / 2);
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	
	
	Scene_MajiangBattle.prototype.duimianStatusWindowRect = function()
	{
		const ww = this.battlerStatusWindowWidth();
    	const wh = this.battlerStatusWindowHeight();
    	
    	const wx = Math.floor((Graphics.boxWidth - ww) / 2);
    	const wy = this.zhuo.top - wh;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	
	Scene_MajiangBattle.prototype.kamijiaStatusWindowRect = function()
	{
		const ww = this.battlerStatusWindowHeight();
    	const wh = this.battlerStatusWindowWidth();
    	
    	const wx = (this.zhuo.left - ww) - this.zhuoPadding();
    	const wy = Math.floor((Graphics.boxHeight - wh) / 2);
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangBattle.prototype.refreshAllEchoWindows = function()
	{
		for(const win in this._echoWindows)
		{
			this._echoWindows[win].refresh();
		}
	};
	
	
	
	
	
	
	
	
	Scene_MajiangBattle.prototype.createZijiaAreas = function()
	{
		this.createZijiaArea();
		this.createZijiaFuluArea();
		this.createZijiaTehaiWindow();
		this.createZijiaHeArea();
		this.createZijiaLizhiboPoint();
		
		
	};
	Scene_MajiangBattle.prototype.createDuimianAreas = function()
	{
		this.createDuimianArea();
		this.createDuimianFuluArea();
		this.createDuimianTehaiArea();
		this.createDuimianHeArea();
		this.createDuimianLizhiboPoint();
		
	};
	Scene_MajiangBattle.prototype.createShimojiaAreas = function()
	{
		this.createShimojiaArea();
		this.createShimojiaFuluArea();
		this.createShimojiaTehaiArea();
		this.createShimojiaHeArea();
		this.createShimojiaLizhiboPoint();
		
	};
	Scene_MajiangBattle.prototype.createKamijiaAreas = function()
	{
		
		this.createKamijiaArea();
		this.createKamijiaFuluArea();
		this.createKamijiaTehaiArea();
		this.createKamijiaHeArea();
		this.createKamijiaLizhiboPoint();
		
	};
	
	//雀卓の領域
	Scene_MajiangBattle.prototype.createZhuo = function()
	{
		const padding = this.zhuoPadding();
		const w = this.majiangBoxWidth() - (padding * 4);
    	const h = this.majiangBoxHeight() - (padding * 2);
    	const x = (padding * 2) + this.horzMargin();
    	const y = padding + this.vartMargin();
    	const rect = new Rectangle(x, y, w, h);
    	this.zhuo = rect;
	};
	
	
	
	//自家の領域
	Scene_MajiangBattle.prototype.createZijiaArea = function()
	{
		
		const w = this.battlerWidth();
		const h = this.battlerHeight();;
		const y = this.zhuo.bottom - h ;
		
		const x = this.zhuo.x + (this.zhuo.width - w) / 2;
		
    	
    	const rect = new Rectangle(x, y, w, h);
    	this.zijiaArea = rect;
    	
    	
	};
	
	//対面の領域
	Scene_MajiangBattle.prototype.createDuimianArea = function()
	{
		
		const w = this.battlerWidth();
		const h = this.battlerHeight();;
		const y = this.zhuo.top;
		
		const x = this.zhuo.x + (this.zhuo.width - w) / 2;
		
    	const rect = new Rectangle(x, y, w, h);
    	this.duimianArea = rect;
    	
    	
	};
	

	//下家の領域
	Scene_MajiangBattle.prototype.createShimojiaArea = function()
	{
		const w = this.battlerHeight();
		const h = this.battlerWidth();
		
		const x = this.zhuo.right - w ;
		const y = this.zhuo.y + (this.zhuo.height - h) / 2; ;
		
		
    	const rect = new Rectangle(x, y, w, h);
    	this.shimojiaArea = rect;
    	
    	
	};
	
	//上家の領域
	Scene_MajiangBattle.prototype.createKamijiaArea = function()
	{
		const w = this.battlerHeight();
		const h = this.battlerWidth();
		
		const x = this.zhuo.left;
		const y = this.zhuo.y + (this.zhuo.height - h) / 2; ;
		
		
    	const rect = new Rectangle(x, y, w, h);
    	this.kamijiaArea = rect;
    	
    	
	};
	
	Scene_MajiangBattle.prototype.zhuoPadding = function()
	{
		return $dataMajiangSystem.params.zhuoPadding;
	};
	
	Scene_MajiangBattle.prototype.horzMargin = function()
	{
		return ($dataMajiangSystem.params.zhuoHorzMargin || 0);
	};
		
	Scene_MajiangBattle.prototype.vartMargin = function()
	{
		return ($dataMajiangSystem.params.zhuoVartMargin || 0);
	};
	
	Scene_MajiangBattle.prototype.majiangBoxWidth = function()
	{
		return Graphics.boxWidth - (this.horzMargin() * 2);
	};
	
	Scene_MajiangBattle.prototype.majiangBoxHeight = function()
	{
		return Graphics.boxHeight - (this.vartMargin() * 2);
	};
	
	
	
	//雀卓の中心X
	Scene_MajiangBattle.prototype.originX = function()
	{
		return this.zhuo.x + this.zhuo.width / 2;
	};
	//雀卓の中心Y
	Scene_MajiangBattle.prototype.originY = function()
	{
		return this.zhuo.y + this.zhuo.height / 2;
	};
	//雀士領域の高さ
	Scene_MajiangBattle.prototype.battlerHeight = function()
	{
		return Math.floor((this.zhuo.height / 2) * 0.7) ;
	};
	//雀士領域の横幅
	Scene_MajiangBattle.prototype.battlerWidth = function()
	{
		return Math.floor(this.zhuo.height * 1);
	};
	//河の高さ
	Scene_MajiangBattle.prototype.heHeight = function()
	{
		return $dataMajiangSystem.tajiaPaiHeight * 4;
	};
	//河の横幅
	Scene_MajiangBattle.prototype.heWidth = function()
	{
		return $dataMajiangSystem.tajiaPaiWidth * $dataMajiangSystem.params.heCols;
	};
	/*Scene_MajiangBattle.prototype.heOffset = function()
	{
		return 10;
	};*/
	
	//副露エリアの高さ
	Scene_MajiangBattle.prototype.fuluHeight = function()
	{
		return $dataMajiangSystem.tajiaPaiWidth * 2;
	};
	//副露エリアの横幅
	Scene_MajiangBattle.prototype.fuluWidth = function()
	{
		const maxFuluWidth = ($dataMajiangSystem.tajiaPaiWidth * 3) + $dataMajiangSystem.tajiaPaiHeight;
		return (maxFuluWidth * 4) + ($dataMajiangSystem.paiSpacing * 3);
	};
	
	//他家手牌の横幅
	Scene_MajiangBattle.prototype.tajiaTehaiWidth = function()
	{
		return $dataMajiangSystem.tajiaPaiWidth * 15;
	};
	//他家手牌の高さ
	Scene_MajiangBattle.prototype.tajiaTehaiHeight = function()
	{
		return $dataMajiangSystem.tajiaPaiHeight;
	};
	
	//自家手牌の横幅
	Scene_MajiangBattle.prototype.zijiaTehaiWindowWidth = function()
	{
		return $dataMajiangSystem.paiWidth * 14 + $dataMajiangSystem.zimoSpacing;
	};
	//自家手牌の高さ
	Scene_MajiangBattle.prototype.zijiaTehaiWindowHeight = function()
	{
		return $dataMajiangSystem.paiHeight;
	};
	
	Scene_MajiangBattle.prototype.lizhiboOffset = function()
	{
		return Math.floor($dataMajiangSystem.tajiaPaiWidth / 2);
	};
	
	//自家-------
	
	Scene_MajiangBattle.prototype.createZijiaTehaiWindow = function() 
	{
    	const rect = this.zijiaTehaiWindowRect();
    	this._zijiaTehaiWindow = new Window_MajiangTehai(rect,0);
    	
    	
    	this._zijiaTehaiWindow.setHandler("ok", this.onDapaiOk.bind(this));
    	if(this.canTerminate())
    	{
    		this._zijiaTehaiWindow.setHandler("cancel", this.onDapaiCancel.bind(this));
    	}
    	this._paiLayer.addSprite(this._zijiaTehaiWindow);
    	//this.addWindow(this._zijiaTehaiWindow);
    	
	};
	
	
	Scene_MajiangBattle.prototype.zijiaTehaiWindowRect = function() 
	{
    	const ww = this.zijiaTehaiWindowWidth();
    	const wh = this.zijiaTehaiWindowHeight();
    	
    	const wx = this.zijiaArea.x + (this.zijiaArea.width - ww) / 2;
    	const wy = this.zijiaArea.bottom - wh;
    	return new Rectangle(wx, wy, ww, wh);
    	
	};
	
	Scene_MajiangBattle.prototype.createZijiaHeArea = function() 
	{
    	const rect = this.zijiaHeAreaRect();
    	
    	this._zijiaHeArea = new Spriteset_MajiangPaizi(rect,0);
    	this._zijiaHeArea.setMaxCols($dataMajiangSystem.params.heCols);
    	this._zijiaHeArea.setMaxRows($dataMajiangSystem.params.heRows);
    	this._paiLayer.addSprite(this._zijiaHeArea);
    	
    	
	};
	
	Scene_MajiangBattle.prototype.zijiaHeAreaRect = function() 
	{
    	const ww = this.heWidth();
    	const wh = this.heHeight();
    	const wx = this.zijiaArea.x + (this.zijiaArea.width - ww) / 2;
    	const wy = this.zijiaArea.top;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangBattle.prototype.createZijiaFuluArea = function() 
	{
    	const rect = this.zijiaFuluAreaRect();
    	this._zijiaFuluArea = new Spriteset_MajiangPaizi(rect,0);
    	
    	this._paiLayer.addSprite(this._zijiaFuluArea);
    	
    	
	};
	
	
	
	Scene_MajiangBattle.prototype.zijiaFuluAreaRect = function() 
	{
    	const ww = this.fuluWidth();
    	const wh = this.fuluHeight();
    	const zijiaFuluOffset = $dataMajiangSystem.params.zijaFuluOffset || 0;
    	const wx = (this.zhuo.right - ww) - zijiaFuluOffset;
    	const wy = this.zijiaArea.bottom - wh;
    	return new Rectangle(wx, wy, ww, wh);
	};
	

	
	Scene_MajiangBattle.prototype.createZijiaLizhiboPoint = function() 
	{
		const x = this.zijiaArea.x + (this.zijiaArea.width / 2);
		const y = this.zijiaArea.top - this.lizhiboOffset();
		this._zijiaLizhibo = new Sprite_MajiangLizhibo(x,y,0);
    	this._paiLayer.addSprite(this._zijiaLizhibo);
	};
	
	
	//対面-------
	
	Scene_MajiangBattle.prototype.createDuimianTehaiArea = function() 
	{
    	const rect = this.duimianTehaiAreaRect();
    	this._duimianTehaiArea = new Spriteset_MajiangPaizi(rect,2);
    	this._paiLayer.addSprite(this._duimianTehaiArea);
    	
    	
    	
	};
	
	Scene_MajiangBattle.prototype.duimianTehaiAreaRect = function() 
	{
    	const ww = this.tajiaTehaiWidth();
    	const wh = this.tajiaTehaiHeight();
    	
    	const wx = this.duimianArea.x + (this.duimianArea.width - ww) / 2;
    	const wy = this.duimianArea.top;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangBattle.prototype.createDuimianHeArea = function() 
	{
    	const rect = this.duimianHeAreaRect();
    	
    	this._duimianHeArea = new Spriteset_MajiangPaizi(rect,2);
    	this._duimianHeArea.setMaxCols($dataMajiangSystem.params.heCols);
    	this._duimianHeArea.setMaxRows($dataMajiangSystem.params.heRows);
    	this._paiLayer.addSprite(this._duimianHeArea);
    	
    	
	};
	
	Scene_MajiangBattle.prototype.duimianHeAreaRect = function() 
	{
    	const ww = this.heWidth();
    	const wh = this.heHeight();
    	const wx = this.duimianArea.x + (this.duimianArea.width - ww) / 2;
    	const wy = this.duimianArea.bottom - wh;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangBattle.prototype.createDuimianFuluArea = function() 
	{
    	const rect = this.duimianFuluAreaRect();
    	this._duimianFuluArea = new Spriteset_MajiangPaizi(rect,2);
    	
    	this._paiLayer.addSprite(this._duimianFuluArea);
    	
	};
	
	
	
	Scene_MajiangBattle.prototype.duimianFuluAreaRect = function() 
	{
    	const ww = this.fuluWidth();
    	const wh = this.fuluHeight();
    	const wx = this.duimianArea.left;
    	const wy = this.duimianArea.top;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	
	Scene_MajiangBattle.prototype.createDuimianLizhiboPoint = function() 
	{
		const x = this.duimianArea.x + (this.duimianArea.width / 2);
		const y = this.duimianArea.bottom + this.lizhiboOffset();
		this._duimianLizhibo = new Sprite_MajiangLizhibo(x,y,2);
    	this._paiLayer.addSprite(this._duimianLizhibo);
    	
	};
	
	//下家-----
	
	Scene_MajiangBattle.prototype.createShimojiaTehaiArea = function() 
	{
    	const rect = this.shimojiaTehaiAreaRect();
    	this._shimojiaTehaiArea = new Spriteset_MajiangPaizi(rect,1);
    	this._paiLayer.addSprite(this._shimojiaTehaiArea);
    	
    	
	};
	
	Scene_MajiangBattle.prototype.shimojiaTehaiAreaRect = function() 
	{
    	const ww = this.tajiaTehaiHeight();
    	const wh = this.tajiaTehaiWidth();
    	
    	const wx = this.shimojiaArea.right - ww;
    	const wy = this.shimojiaArea.y + (this.shimojiaArea.height - wh) / 2;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangBattle.prototype.createShimojiaHeArea = function() 
	{
    	const rect = this.shimojiaHeAreaRect();
    	
    	this._shimojiaHeArea = new Spriteset_MajiangPaizi(rect,1);
    	this._shimojiaHeArea.setMaxCols($dataMajiangSystem.params.heCols);
    	this._shimojiaHeArea.setMaxRows($dataMajiangSystem.params.heRows);
    	this._paiLayer.addSprite(this._shimojiaHeArea);
    	
    	
	};
	
	Scene_MajiangBattle.prototype.shimojiaHeAreaRect = function() 
	{
    	const ww = this.heHeight();
    	const wh = this.heWidth()
    	const wx = this.shimojiaArea.x ;
    	const wy = this.shimojiaArea.y + (this.shimojiaArea.height - wh) / 2;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangBattle.prototype.createShimojiaFuluArea = function() 
	{
    	const rect = this.shimojiaFuluAreaRect();
    	this._shimojiaFuluArea = new Spriteset_MajiangPaizi(rect,1);
    	
    	this._paiLayer.addSprite(this._shimojiaFuluArea);
    	
	};
	
	
	
	Scene_MajiangBattle.prototype.shimojiaFuluAreaRect = function() 
	{
    	const ww = this.fuluHeight();
    	const wh = this.fuluWidth();
    	const wx = this.shimojiaArea.right - ww;
    	const wy = this.shimojiaArea.y;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangBattle.prototype.createShimojiaLizhiboPoint = function() 
	{
		const x = this.shimojiaArea.left - this.lizhiboOffset();
		const y = this.shimojiaArea.y + (this.shimojiaArea.height / 2);
		this._shimojiaLizhibo = new Sprite_MajiangLizhibo(x,y,1);
    	this._paiLayer.addSprite(this._shimojiaLizhibo);
	};
	
	//上家-----
	
	Scene_MajiangBattle.prototype.createKamijiaTehaiArea = function() 
	{
    	const rect = this.kamijiaTehaiAreaRect();
    	this._kamijiaTehaiArea = new Spriteset_MajiangPaizi(rect,3);
    	this._paiLayer.addSprite(this._kamijiaTehaiArea);
    	
	};
	
	Scene_MajiangBattle.prototype.kamijiaTehaiAreaRect = function() 
	{
    	const ww = this.tajiaTehaiHeight();
    	const wh = this.tajiaTehaiWidth();
    	
    	const wx = this.kamijiaArea.x;
    	const wy = this.kamijiaArea.y + (this.kamijiaArea.height - wh) / 2;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangBattle.prototype.createKamijiaHeArea = function() 
	{
    	const rect = this.kamijiaHeAreaRect();
    	
    	this._kamijiaHeArea = new Spriteset_MajiangPaizi(rect,3);
    	this._kamijiaHeArea.setMaxCols($dataMajiangSystem.params.heCols);
    	this._kamijiaHeArea.setMaxRows($dataMajiangSystem.params.heRows);
    	this._paiLayer.addSprite(this._kamijiaHeArea);
    	
	};
	
	Scene_MajiangBattle.prototype.kamijiaHeAreaRect = function() 
	{
    	const ww = this.heHeight();
    	const wh = this.heWidth()
    	const wx = this.kamijiaArea.right - ww ;
    	const wy = this.kamijiaArea.y + (this.kamijiaArea.height - wh) / 2;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangBattle.prototype.createKamijiaFuluArea = function() 
	{
    	const rect = this.kamijiaFuluAreaRect();
    	this._kamijiaFuluArea = new Spriteset_MajiangPaizi(rect,3);
    	
    	this._paiLayer.addSprite(this._kamijiaFuluArea);
    	
	};
	
	
	
	Scene_MajiangBattle.prototype.kamijiaFuluAreaRect = function() 
	{
    	const ww = this.fuluHeight();
    	const wh = this.fuluWidth();
    	const wx = this.kamijiaArea.x;
    	const wy = this.kamijiaArea.bottom - wh;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	
	Scene_MajiangBattle.prototype.createKamijiaLizhiboPoint = function() 
	{
		const x = this.kamijiaArea.right + this.lizhiboOffset();
		const y = this.kamijiaArea.y + (this.kamijiaArea.height / 2);
		this._kamijiaLizhibo = new Sprite_MajiangLizhibo(x,y,3);
    	this._paiLayer.addSprite(this._kamijiaLizhibo);
	};
	
	
	
	
	
	
	Scene_MajiangBattle.prototype.gameEnd = function() 
	{
		MajiangManager.terminate(true);
		this.startFadeOut(this.fadeSpeed(),false);
		this.popScene();
	};
	
	Scene_MajiangBattle.prototype.popScene = function()
	{
		const prevScene = $gameMajiangSystem.prevScene();
		if(prevScene)
		{
			SceneManager.goto(prevScene);
		}
		else
		{
			Scene_Message.prototype.popScene.call(this);
		}
		$gameMajiangSystem.clearPrevScene();
	};
	
	
	Scene_MajiangBattle.prototype.syncBattlerPaizi = function() 
	{
		this.refreshAllEchoWindows();
		
		const zijia = $gameMajiangBattlers.zijia();
		this._zijiaTehaiWindow.setTehai(zijia.tehai());
		this._zijiaHeArea.addPaizi(zijia.realHe());
		this._zijiaFuluArea.addFulu(zijia.fulu());
		this._zijiaLizhibo.setVisible();
		
		for(const position of [1,2,3])
		{
			const pt = ["","shimojia","duimian","kamijia"][position];
			
			if(!MajiangManager.checkPosition(position)) continue;
			
			const battler = $gameMajiangBattlers.battler(position);
			
			this["_" + pt + "TehaiArea"].addPaizi(battler.tehai());
			this["_" + pt + "HeArea"].addPaizi(battler.realHe());
			this["_" + pt + "FuluArea"].addFulu(battler.fulu());
			this["_" + pt + "Lizhibo"].setVisible();
		}
		
	};
	
	
	
	Scene_MajiangBattle.prototype.startGameEndMenu = function() 
	{
		this._openGameEndMenu = true;
		this._gameEndMenuWindow.activate();
		this._gameEndMenuWindow.open();
	};
	
	Scene_MajiangBattle.prototype.cancelGameEndMenu = function() 
	{
		this._openGameEndMenu = false;
		this._gameEndMenuWindow.deactivate();
		this._gameEndMenuWindow.close();
		if(this._dapaiSelecting)
		{
			this._zijiaTehaiWindow.activate();
			this._dapaiSelecting = false;
		}
	};
	
	
	
	Scene_MajiangBattle.prototype.openAllWindows = function() 
	{
		for(const win in this._echoWindows)
		{
			this._echoWindows[win].open();
		}
	};
	Scene_MajiangBattle.prototype.closeAllWindows = function() 
	{
		for(const win in this._echoWindows)
		{
			this._echoWindows[win].close();
		}
	};
		
	Scene_MajiangBattle.prototype.closeStatusWindow = function() 
	{
		this._echoWindows.status.close();
	};
	
	
	
	Scene_MajiangBattle.prototype.isBusy = function() 
	{
		return (
        	this._majiangMessageWindow.isClosing()
        	|| Scene_Base.prototype.isBusy.call(this)
        	|| this.anyAnimationPlaying()
    	);
    	
	};
	
	Scene_MajiangBattle.prototype.anyAnimationPlaying = function() 
	{
		
		return this._paiLayer.isBusy();
	};
	
	
	Scene_MajiangBattle.prototype.update = function() 
	{
		Scene_Base.prototype.update.call(this);
    	const active = this.isActive();
    	if (active && !this.isBusy() && !this._openGameEndMenu) 
    	{
    		if(this.canCalledGameEndMenu() && this.calledGameEndMenu())
    		{
    			this.startGameEndMenu();
	    	}
    	    this.updateBattleProcess();
    	    this.checkRequests();
    	}
    	
    	this.updateVisibility();
    	this.updateMain();
    	
	};
	Scene_MajiangBattle.prototype.updateMain = function() 
	{
		
		$gameScreen.update();
    	//
	};
	
	Scene_MajiangBattle.prototype.canTerminate = function() 
	{
    	return $gameMajiangSystem.condition.abstention;
	};
	
	
	Scene_MajiangBattle.prototype.canCalledGameEndMenu = function() 
	{
    	return (this.canTerminate() && MajiangManager.canCalledGameEndMenu() && !this.isAnyWindowActive());
	};
	
	Scene_MajiangBattle.prototype.calledGameEndMenu = function()
	{
		return (Input.isTriggered("cancel"));
	};
	
	Scene_MajiangBattle.prototype.checkRequests = function() 
	{
		const requests = MajiangManager.requests();
		
		while(requests.length > 0)
		{
			const req = requests.shift();
			switch(req)
			{
				case "sync" : 
					this.syncBattlerPaizi();
				break;
				case "fadeIn" : 
					this.startFadeIn(this.fadeSpeed(),false);
				break;
				case "fadeOut" : 
					this.startFadeOut(this.fadeSpeed(),false);
				break;
				case "nextGameScene" : 
					//this.nextGameScene();
				break;
				case "openAllWindows" : 
					this.openAllWindows();
				break;
				case "closeAllWindows" : 
					this.closeAllWindows();
				break;
				case "closeStatusWindow" : 
					this.closeStatusWindow();
				break;
				case "inputDapai" : 
					this.startDapai();
				break;
				case "startChoice" : 
					this.startChoice();
				break;
				case "terminate" : 
					this.gameEnd();
				break;
			}
			
		}
		
	};
	
	
	
	Scene_MajiangBattle.prototype.updateBattleProcess = function() 
	{
		
		MajiangManager.update(this.isTimeActive());
	};
	
	Scene_MajiangBattle.prototype.isTimeActive = function() 
	{
		return !this.isAnyWindowActive();
	};
	
	Scene_MajiangBattle.prototype.isAnyWindowActive = function() 
	{
		return (
    		this.isMessageWindowRunning() ||
    		this.isChoiceWindowRunning() ||
    		this.isAnyInputWindowActive()
        );
	};
	
	Scene_MajiangBattle.prototype.isMessageWindowRunning = function() 
	{
		return (!this._majiangMessageWindow.isClosed());
	};
	
	Scene_MajiangBattle.prototype.isChoiceWindowRunning = function() 
	{
		return (!this._choiceWindow.isClosed());
	};
	
	Scene_MajiangBattle.prototype.updateVisibility = function() 
	{
		this.updateCancelButton();
		if(this._echoWindows.tingpaiMachi)
		{
			this.updateTingpaiMachiWindow();
		}
		
	};
	
	Scene_MajiangBattle.prototype.updateTingpaiMachiWindow = function() 
	{
		this._echoWindows.tingpaiMachi.canOpen = (
			!!$dataMajiangSystem.params.tingpaiMachiWindow
			&& this._choiceWindow.isClosed()
			&& MajiangManager.canCalledGameEndMenu()
			&& ($dataMajiangSystem.params.tingpaiMachiWindow !== 2 
				|| this._zijiaTehaiWindow.active
			)
		);
	};
		
	Scene_MajiangBattle.prototype.startChoice = function() 
	{
		this._choiceWindow.start();
	};
	
	
	
	
	
	Scene_MajiangBattle.prototype.updateCancelButton = function() 
	{
	    if (this._cancelButton) 
	    {
	        this._cancelButton.visible = (this.isAnyNeedsCancelButtonWindowActive() || this.canCalledGameEndMenu());
	    }
	};
	
	Scene_MajiangBattle.prototype.isAnyNeedsCancelButtonWindowActive = function() 
	{
		return (
        	this._choiceWindow.active
        	|| this._gameEndMenuWindow.active
        	|| (this._zijiaTehaiWindow.active && this.canTerminate())
        	
    	);
	};
	
	Scene_MajiangBattle.prototype.isAnyInputWindowActive = function() 
	{
		return (
        	this._choiceWindow.active
        	|| this._gameEndMenuWindow.active
        	|| this._zijiaTehaiWindow.active
        	
    	);
	};
	
	Scene_MajiangBattle.prototype.startDapai = function() 
	{
        this._zijiaTehaiWindow.activate();
        
		this._zijiaTehaiWindow.selectZimopai();
    };
	
	Scene_MajiangBattle.prototype.onDapaiOk = function()
	{
		const pai = this._zijiaTehaiWindow.item();
		MajiangManager.applyDapaiPlayer(pai);
		this._zijiaTehaiWindow.deactivate();
		$gameMajiangPaishan.allData().forEach(p => p.deselect());
	};
	
	Scene_MajiangBattle.prototype.onDapaiCancel = function()
	{
		if(MajiangManager.isLizhiSelecting())
		{
			MajiangManager.cancelLizhiSelect();
			this._zijiaTehaiWindow.activate();
			this.syncBattlerPaizi();
		}
		else
		{
			this._dapaiSelecting = true;
			this.startGameEndMenu();
		}
		
	};
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	Scene_MajiangResult.prototype.initialize = function()
	{
		Scene_Base.prototype.initialize.call(this);
		this._fadeOpacity = 255;
		this.updateColorFilter();
		
		this._nextScene = null;
		this.setSection();
		
		this._audioRequest = null;
		
	};
	
	Scene_MajiangResult.prototype.create = function() 
	{
    	Scene_Base.prototype.create.call(this);
    	this.createBackground();
    	
    	this.createWindowLayer();
    	
    	this.createAllWindows();
    	
	};
	
	Scene_MajiangResult.prototype.start = function() 
	{
    	Scene_Base.prototype.start.call(this);
    	
    	
    	this._tehaiWindow.refresh();
    	this._liujuWindows.forEach(w => w.refresh());
    	this._finalResultWindows.forEach(w => w.refresh());
    	this._pointWindows.forEach(w => w.refresh());
    	
	};
	
	Scene_MajiangResult.prototype.createBackground = function()
	{
    	this._backgroundSprite = new Sprite();
		const backgroundImg = $gameMajiangSystem.imgData.majiangBackground;
		if(backgroundImg)
		{
			this._backgroundSprite.bitmap = ImageManager.loadPicture(backgroundImg);
			this.centerSprite(this._backgroundSprite);
		}
		else
		{
			this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
			const filterSetting = $dataMajiangSystem.params.backGroundFilter;
			if(filterSetting !== 0)
			{
				if(filterSetting == 2)
				{
					this._backgroundFilter = new PIXI.filters.BlurFilter();
    				this._backgroundSprite.filters = [this._backgroundFilter];
    			}
    			this.setBackgroundOpacity(192);
    		}
    		
		}
		this.addChild(this._backgroundSprite);
		
	};
	
	Scene_MajiangResult.prototype.setBackgroundOpacity = function(opacity) 
	{
    	this._backgroundSprite.opacity = opacity;
	};
	
	
	
	Scene_MajiangResult.prototype.createAllWindows = function() 
	{
		//this.setHelejia();
		this.createResultWindows();
		this.createAllPointWindows();
	};
	
	Scene_MajiangResult.prototype.setHelejia = function(battler) 
	{
		this._helejia = battler;
		
		this._yakuWindow.setBattler(this._helejia);
		this._tehaiWindow.setBattler(this._helejia,true);
		
	};
	
	
	
	Scene_MajiangResult.prototype.createResultWindows = function() 
	{
		this.createTehaiWindow() ;
		this.createYakuWindow() ;
		this.createAllLiujuWindows();
		this.createAllFinalResultWindows();
    	
    	
	};
	
	
	Scene_MajiangResult.prototype.resultWindowX = function()
	{
		
		const ww = this.resultWindowWidth();
		
		return Math.floor((Graphics.boxWidth - ww) / 2);
	};
	
	Scene_MajiangResult.prototype.resultWindowWidth = function()
	{
		const w = Math.floor(Graphics.boxWidth / 1.2)
		return Math.floor(w / 2) * 2 ;
	};
		
	
	
	
	Scene_MajiangResult.prototype.createTehaiWindow = function(battler) 
	{
    	const rect = this.tehaiWindowRect();
    	const tehaiWindow = new Window_MajiangResultTehai(rect);
    	tehaiWindow.hide();
    	//tehaiWindow.setBattler(battler);
    	this.addWindow(tehaiWindow);
    	this._tehaiWindow = tehaiWindow;
	};
	
	Scene_MajiangResult.prototype.tehaiWindowHeight = function() 
	{
		return Math.floor(Graphics.boxHeight  / 4);
	};
	
	Scene_MajiangResult.prototype.tehaiWindowRect = function() 
	{
    	const ww = this.resultWindowWidth();
    	const wh = this.tehaiWindowHeight();
    	const wx = this.resultWindowX();
    	const wy = 0;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	
	Scene_MajiangResult.prototype.createYakuWindow = function(battler) 
	{
    	const rect = this.yakuWindowRect();
    	const yakuWindow = new Window_MajiangResultYaku(rect);
    	//yakuWindow.setBattler(battler);
    	yakuWindow.hide();
    	this.addWindow(yakuWindow);
    	
    	this._yakuWindow = yakuWindow;
	};
	
	Scene_MajiangResult.prototype.yakuWindowRect = function() 
	{
    	const ww = this.resultWindowWidth();
    	const wh = Graphics.boxHeight - this.pointWindowHeight() - this.tehaiWindowHeight();
    	const wx = this.resultWindowX();
    	const wy = this.tehaiWindowHeight();
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangResult.prototype.createAllLiujuWindows = function() 
	{
		this._liujuWindows = [];
		if(MajiangManager.liuju() === "huangpaiPingju")
		{
			$gameMajiangBattlers.allBattlers().forEach(function(b,i)
			{
    			this.createLiujuWindow(i,b.position());
    		},this);
    	}
	};
	
	Scene_MajiangResult.prototype.createLiujuWindow = function(index,position) 
	{
		const rect = this.liujuWindowRect(index);
    	const liujuWindow = new Window_MajiangResultTehai(rect);
    	liujuWindow.setBattler($gameMajiangBattlers.battler(position),false);
    	liujuWindow.hide();
    	this.addWindow(liujuWindow);
    	this._liujuWindows.push(liujuWindow);
	};
	
	Scene_MajiangResult.prototype.liujuWindowRect = function(index) 
	{
		const ww = this.resultWindowWidth();
    	const wh = (Graphics.boxHeight - this.pointWindowHeight()) / MajiangManager.numBattlers() ;
    	const wx = this.resultWindowX();
    	const wy = wh * index;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangResult.prototype.createAllPointWindows = function() 
	{
		this._pointWindows = [];
		$gameMajiangBattlers.allBattlers().forEach(function(b,i)
		{
    		this.createPointWindow(i,b.position());
    	},this);
    	
	};
	
	Scene_MajiangResult.prototype.createPointWindow = function(index,position) 
	{
		const rect = this.pointWindowRect(index);
    	const pointWindow = new Window_MajiangResultPoint(rect);
    	pointWindow.setBattler($gameMajiangBattlers.battler(position));
    	pointWindow.hide();
    	this.addWindow(pointWindow);
    	
    	this._pointWindows.push(pointWindow);
    	
	};
	
	Scene_MajiangResult.prototype.pointWindowHeight = function()
	{
		return this.calcWindowHeight(3 , false);
	};
	
	Scene_MajiangResult.prototype.calcWindowHeight = function(numLines, selectable) 
	{
		if(!$dataMajiangSystem.params.lineHeight)
		{
			return Scene_Base.prototype.calcWindowHeight.call(this,numLines,selectable);
		}
		if (selectable) 
		{
			return Window_Selectable.prototype.fittingHeight(numLines);
		}
		else 
		{
			return Window_MajiangBase.prototype.fittingHeight(numLines);
		}
	};
	
	Scene_MajiangResult.prototype.pointWindowWidth = function()
	{
		return Math.floor(Graphics.boxWidth  / MajiangManager.numBattlers());
	};
	
	Scene_MajiangResult.prototype.pointWindowRect = function(index) 
	{
		const ww = this.pointWindowWidth();
    	const wh = this.pointWindowHeight();
    	const wx = index * ww;
    	const wy = Graphics.boxHeight - wh;
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	Scene_MajiangResult.prototype.createAllFinalResultWindows = function() 
	{
		this._finalResultWindows = [];
		
   		for(let i = 0; i < MajiangManager.numBattlers() ; i++)
		{
    		this.createFinalResultWindow(i);
    	}
	};
		
	Scene_MajiangResult.prototype.createFinalResultWindow = function(index) 
	{
		const rect = this.finalResultWindowRect(index);
    	const finalResultWindow = new Window_MajiangResultFinalPoint(rect);
    	finalResultWindow.hide();
    	this.addWindow(finalResultWindow);
    	this._finalResultWindows.push(finalResultWindow);
	};
	
	Scene_MajiangResult.prototype.finalResultWindowRect = function(index) 
	{
		const ww = Math.floor(Graphics.boxWidth / 1.5);
    	const wh = Math.floor((Graphics.boxHeight) / (2 + MajiangManager.numBattlers())) ;
    	let wx = (Graphics.boxWidth - ww) / 2;
    	wx = Math.floor(wx / 2) * 2;
    	const wy = wh * (index + 1);
    	return new Rectangle(wx, wy, ww, wh);
	};
	
	
	Scene_MajiangResult.prototype.update = function() 
	{
		Scene_Base.prototype.update.call(this);
    	const active = this.isActive();
    	
		
    	if (active && !this.isBusy()) 
    	{
    		this.playAudio();
	    	if(this._requestNextSection)
	    	{
	    		const currentSection = this.currentSection();
	    		
	    		if(currentSection)
	    		{
	    			this.startSection();
		    	}
		    	else
		    	{
		   			this.startEndScene(Scene_Map);
				}
			}
			else if(this.pressAnyKey())
    		{
    			this.nextSection();
	    	}
	    }
	};
	
	Scene_MajiangResult.prototype.playAudio = function()
	{
		if(this._audioRequest)
		{
			MajiangManager.playAudio(this._audioRequest)
		}
		this._audioRequest = null;
		
	};
	
	Scene_MajiangResult.prototype.showLiujuWindows = function()
	{
		this._liujuWindows.forEach(w => w.show());
	};
	
	Scene_MajiangResult.prototype.setFinalResult = function()
	{
		this._finalResultWindows.forEach(function(w,i)
		{
			const finalResult = MajiangManager.finalResult()[i];
			w.setFinalResult(finalResult)
		});
	};
	
	Scene_MajiangResult.prototype.showFinalResultWindows = function()
	{
		this._finalResultWindows.forEach(w => w.show());
	};
	
	Scene_MajiangResult.prototype.hideAllWindows = function()
	{
		this._tehaiWindow.hide();
		this._yakuWindow.hide();
		this._liujuWindows.forEach(w => w.hide());
		this._pointWindows.forEach(w => w.hide());
	};
	
	Scene_MajiangResult.prototype.showHeleWindows = function()
	{
		this._tehaiWindow.show();
		this._yakuWindow.show();
	};
	
	Scene_MajiangResult.prototype.showPointWindows = function()
	{
		this._pointWindows.forEach(w => w.show());
	};
			
	Scene_MajiangResult.prototype.pressAnyKey = function()
	{
		return (Input.isPressed("ok") || Input.isPressed("cancel") || TouchInput.isClicked() || TouchInput.isCancelled());
	};
	
			
	Scene_MajiangResult.prototype.setSection = function() 
	{
		this._index = 0;
		this._requestNextSection = true;
		
		this._sections = MajiangManager.resultSequence();
	};
	
	Scene_MajiangResult.prototype.currentSection = function() 
	{
		return this._sections[this._index];
	};
	
	Scene_MajiangResult.prototype.nextSection = function() 
	{
		this._index++;
    	this._requestNextSection = true;
    	this.endSection();
	};
	/*Scene_MajiangResult.prototype.startEndScene = function(scene) 
	{
		
		SceneManager.goto(scene);
	};*/
	Scene_MajiangResult.prototype.endSection = function() 
	{
		this.startFadeOut(this.fadeSpeed(),false);
	};
	
	Scene_MajiangResult.prototype.startSection = function() 
	{
		this.hideAllWindows();
		this._requestNextSection = false;
		const section = this.currentSection();
		
		if(!section.gotoNext)
		{
			this.startFadeIn(this.fadeSpeed(),false);
		}
		
		this.applySection(this.currentSection());
	};
	
	Scene_MajiangResult.prototype.applySection = function(section) 
	{
		switch(section.kind)
		{
			case "liuju" : this.sectionLiuju(); break;
			case "hele" : this.sectionHele(section); break;
			case "finalResult" : this.sectionFinalResult(); break;
			case "nextGame" : this.sectionNextGame(); break;
			case "terminate" : this.sectionTerminate(); break;
			
		}
	};
	
	Scene_MajiangResult.prototype.sectionLiuju = function() 
	{
		this.showLiujuWindows();
		this.showPointWindows();
	};
	
	Scene_MajiangResult.prototype.sectionFinalResult = function() 
	{
		MajiangManager.makeFinalResult();
		
		if(MajiangManager.playerTop())
		{
			this._audioRequest = "victory";
		}
		this.setFinalResult();
		this.showFinalResultWindows();
	};
	
	Scene_MajiangResult.prototype.sectionHele = function(section) 
	{
		const heleResult = section.battler.heleResult();
		
		if(section.battler.isPlayer())
		{
			this._audioRequest = this.findHeleMe(section.battler);
			
		}
		this.setHelejia(section.battler);
		this.showPointWindows();
		this.showHeleWindows();
	};
	
	Scene_MajiangResult.prototype.findHeleMe = function(battler)
	{
		const data = $gameMajiangSystem.audioData;
		const rank = battler.manganRank();
		const table = ["yakuman" , "sambaiman" , "baiman" , "haneman" , "mangan","hele"];
		for(let i = 0 ; i < 6 ; i++)
		{
			let key = table[(5 - rank) + i];
			if(!key) break;
			key = "heleMe_" + key;
			
			if(data[key] && data[key].enabled)
			{
				return key;
			}
		}
		
		return "heleMe_hele";
	};
	
	Scene_MajiangResult.prototype.sectionNextGame = function() 
	{
		MajiangManager.startGame();
		SceneManager.goto(Scene_MajiangBattle);
		
	};
	
	Scene_MajiangResult.prototype.sectionTerminate = function() 
	{
		MajiangManager.terminate(false);
		this.popScene();
	};
	
	Scene_MajiangResult.prototype.popScene = function()
	{
		Scene_MajiangBattle.prototype.popScene.call(this);
	};
	
	
	Scene_MajiangResult.prototype.isBusy = function() 
	{
		return (
        	
        	Scene_Base.prototype.isBusy.call(this)
    	);
    	
	};
	
	
	
	
})();









